/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

public class StandardRecordFormat
extends RecordFormat {
    @Override
    public int getRecordSize() {
        return 16;
    }

    @Override
    public Record createRecord(File file, int recordId) {
        return new StandardRecord(file, recordId);
    }

    @Override
    public Record readRecord(PageCursor cursor) throws IOException {
        long f2;
        int r;
        short f1;
        byte f;
        byte t;
        int offset = cursor.getOffset();
        do {
            cursor.setOffset(offset);
            t = cursor.getByte();
            f = cursor.getByte();
            f1 = cursor.getShort();
            r = cursor.getInt();
            f2 = cursor.getLong();
        } while (cursor.shouldRetry());
        return new StandardRecord(t, f, f1, r, f2);
    }

    @Override
    public Record zeroRecord() {
        byte z = 0;
        return new StandardRecord(z, z, z, z, z);
    }

    @Override
    public void write(Record record, PageCursor cursor) {
        StandardRecord r = (StandardRecord)record;
        cursor.putByte(r.type);
        cursor.putByte(r.file.getName().getBytes()[0]);
        cursor.putShort(r.fill1);
        cursor.putInt(r.recordId);
        cursor.putLong(r.fill2);
    }

    static final class StandardRecord
    implements Record {
        final byte type;
        final File file;
        final int recordId;
        final short fill1;
        final long fill2;

        public StandardRecord(File file, int recordId) {
            this.type = (byte)42;
            this.file = file;
            this.recordId = recordId;
            int fileHash = file.hashCode();
            int a = StandardRecord.xorshift(fileHash ^ StandardRecord.xorshift(recordId));
            int b = StandardRecord.xorshift(a);
            int c = StandardRecord.xorshift(b);
            long d = b;
            d <<= 32;
            this.fill1 = (short)a;
            this.fill2 = d += (long)c;
        }

        public StandardRecord(byte type, byte fileName, short fill1, int recordId, long fill2) {
            this.type = type;
            this.file = fileName == 0 ? null : new File(new String(new byte[]{fileName}));
            this.fill1 = fill1;
            this.recordId = recordId;
            this.fill2 = fill2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StandardRecord record = (StandardRecord)o;
            return this.type == record.type && this.recordId == record.recordId && this.fill1 == record.fill1 && this.fill2 == record.fill2 && !(this.file == null ? record.file != null : !this.file.equals(record.file));
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + this.recordId;
            result = 31 * result + this.fill1;
            result = 31 * result + (int)(this.fill2 ^ this.fill2 >>> 32);
            return result;
        }

        private static int xorshift(int x) {
            x ^= x << 6;
            x ^= x >>> 21;
            return x ^ x << 7;
        }

        public String toString() {
            return this.format(this.type, this.file, this.recordId, this.fill1, this.fill2);
        }

        public String format(byte type, File file, int recordId, short fill1, long fill2) {
            return String.format("Record%s[file=%s, recordId=%s; %04x %016x]", type, file, recordId, fill1, fill2);
        }
    }
}

