/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.function.Consumer;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;

public final class LinearHistoryPageCacheTracer
implements PageCacheTracer {
    private final AtomicReference<HEvent> history = new AtomicReference();
    private final SwitchableBufferedOutputStream bufferOut = new SwitchableBufferedOutputStream();
    private final PrintStream out = new PrintStream(this.bufferOut);
    private final Map<Class<?>, String> classSimpleNameCache = new IdentityHashMap();
    private final HEvent end = new HEvent(){

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(" EOF ");
        }
    };

    <E extends HEvent> E add(E event) {
        HEvent prev = this.history.getAndSet(event);
        event.prev = prev == null ? this.end : prev;
        return event;
    }

    public synchronized boolean processHistory(Consumer<HEvent> processor) {
        HEvent events = this.history.getAndSet(null);
        if (events == null) {
            return false;
        }
        events = this.reverse(events);
        while (events != null) {
            processor.accept((Object)events);
            events = events.prev;
        }
        return true;
    }

    public synchronized void printHistory(PrintStream outputStream) {
        this.bufferOut.setOut(outputStream);
        if (!this.processHistory(new HistoryPrinter())) {
            this.out.println("No events recorded.");
        }
        this.out.flush();
    }

    private HEvent reverse(HEvent events) {
        HEvent current = this.end;
        while (events != this.end) {
            HEvent prev;
            while ((prev = events.prev) == null) {
            }
            events.prev = current;
            current = events;
            events = prev;
        }
        return current;
    }

    public void mappedFile(File file) {
        this.add((LinearHistoryPageCacheTracer)this.new MappedFileHEvent()).file = file;
    }

    public void unmappedFile(File file) {
        this.add((LinearHistoryPageCacheTracer)this.new UnmappedFileHEvent()).file = file;
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.add(new EvictionRunHEvent(pageCountToEvict));
    }

    public PinEvent beginPin(boolean exclusiveLock, long filePageId, PageSwapper swapper) {
        return this.add(new PinHEvent(exclusiveLock, filePageId, swapper));
    }

    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.add(new MajorFlushHEvent(swapper.file()));
    }

    public MajorFlushEvent beginCacheFlush() {
        return this.add(new MajorFlushHEvent(null));
    }

    public long countFaults() {
        return 0L;
    }

    public long countEvictions() {
        return 0L;
    }

    public long countPins() {
        return 0L;
    }

    public long countUnpins() {
        return 0L;
    }

    public long countFlushes() {
        return 0L;
    }

    public long countBytesRead() {
        return 0L;
    }

    public long countBytesWritten() {
        return 0L;
    }

    public long countFilesMapped() {
        return 0L;
    }

    public long countFilesUnmapped() {
        return 0L;
    }

    public long countEvictionExceptions() {
        return 0L;
    }

    private class HistoryPrinter
    implements Consumer<HEvent> {
        private final List<HEvent> concurrentIntervals = new LinkedList<HEvent>();

        public void accept(HEvent event) {
            String exceptionLinePrefix = this.exceptionLinePrefix(this.concurrentIntervals.size());
            if (event.getClass() == EndHEvent.class) {
                EndHEvent endHEvent = (EndHEvent)event;
                int idx = this.concurrentIntervals.indexOf(endHEvent.event);
                this.putcs(LinearHistoryPageCacheTracer.this.out, '|', idx);
                LinearHistoryPageCacheTracer.this.out.print('-');
                int left = this.concurrentIntervals.size() - idx - 1;
                this.putcs(LinearHistoryPageCacheTracer.this.out, '|', left);
                LinearHistoryPageCacheTracer.this.out.print("   ");
                endHEvent.print(LinearHistoryPageCacheTracer.this.out, exceptionLinePrefix);
                this.concurrentIntervals.remove(idx);
                if (left > 0) {
                    LinearHistoryPageCacheTracer.this.out.println();
                    this.putcs(LinearHistoryPageCacheTracer.this.out, '|', idx);
                    this.putcs(LinearHistoryPageCacheTracer.this.out, '/', left);
                }
            } else if (event instanceof IntervalHEven) {
                this.putcs(LinearHistoryPageCacheTracer.this.out, '|', this.concurrentIntervals.size());
                LinearHistoryPageCacheTracer.this.out.print("+   ");
                event.print(LinearHistoryPageCacheTracer.this.out, exceptionLinePrefix);
                this.concurrentIntervals.add(event);
            } else {
                this.putcs(LinearHistoryPageCacheTracer.this.out, '|', this.concurrentIntervals.size());
                LinearHistoryPageCacheTracer.this.out.print(">   ");
                event.print(LinearHistoryPageCacheTracer.this.out, exceptionLinePrefix);
            }
            LinearHistoryPageCacheTracer.this.out.println();
        }

        private String exceptionLinePrefix(int size) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append('|');
            }
            sb.append(":  ");
            return sb.toString();
        }

        private void putcs(PrintStream out, char c, int count) {
            for (int i = 0; i < count; ++i) {
                out.print(c);
            }
        }
    }

    public class MajorFlushHEvent
    extends IntervalHEven
    implements MajorFlushEvent,
    FlushEventOpportunity {
        private File file;

        public MajorFlushHEvent(File file) {
            this.file = file;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public FlushEvent beginFlush(long filePageId, int cachePageId, PageSwapper swapper) {
            return LinearHistoryPageCacheTracer.this.add(new FlushHEvent(filePageId, cachePageId, swapper));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    public class PageFaultHEvent
    extends IntervalHEven
    implements PageFaultEvent {
        private int bytesRead;
        private int cachePageId;
        private boolean parked;
        private Throwable exception;

        public void addBytesRead(int bytes) {
            this.bytesRead += bytes;
        }

        public void setCachePageId(int cachePageId) {
            this.cachePageId = cachePageId;
        }

        public void setParked(boolean parked) {
            this.parked = parked;
        }

        public void done() {
            this.close();
        }

        public void done(Throwable throwable) {
            this.exception = throwable;
            this.done();
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", bytesRead:");
            out.print(this.bytesRead);
            out.print(", parked:");
            out.print(this.parked);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public class PinHEvent
    extends IntervalHEven
    implements PinEvent {
        private boolean exclusiveLock;
        private long filePageId;
        private File file;
        private int cachePageId;

        public PinHEvent(boolean exclusiveLock, long filePageId, PageSwapper swapper) {
            this.exclusiveLock = exclusiveLock;
            this.filePageId = filePageId;
            this.file = swapper.file();
        }

        public void setCachePageId(int cachePageId) {
            this.cachePageId = cachePageId;
        }

        public PageFaultEvent beginPageFault() {
            return LinearHistoryPageCacheTracer.this.add(new PageFaultHEvent());
        }

        public void done() {
            this.close();
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            this.print(out, this.file);
            out.append(", exclusiveLock:");
            out.print(this.exclusiveLock);
        }
    }

    public class FlushHEvent
    extends IntervalHEven
    implements FlushEvent {
        private long filePageId;
        private int cachePageId;
        private File file;
        private int bytesWritten;
        private IOException exception;

        public FlushHEvent(long filePageId, int cachePageId, PageSwapper swapper) {
            this.filePageId = filePageId;
            this.cachePageId = cachePageId;
            this.file = swapper.file();
        }

        public void addBytesWritten(int bytes) {
            this.bytesWritten += bytes;
        }

        public void done() {
            this.close();
        }

        public void done(IOException exception) {
            this.exception = exception;
            this.done();
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            this.print(out, this.file);
            out.print(", bytesWritten:");
            out.print(this.bytesWritten);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public class EvictionHEvent
    extends IntervalHEven
    implements EvictionEvent,
    FlushEventOpportunity {
        private long filePageId;
        private File file;
        private IOException exception;
        private int cachePageId;

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.file = swapper == null ? null : swapper.file();
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public void threwException(IOException exception) {
            this.exception = exception;
        }

        public void setCachePageId(int cachePageId) {
            this.cachePageId = cachePageId;
        }

        public FlushEvent beginFlush(long filePageId, int cachePageId, PageSwapper swapper) {
            return LinearHistoryPageCacheTracer.this.add(new FlushHEvent(filePageId, cachePageId, swapper));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            this.print(out, this.file);
            this.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public class EvictionRunHEvent
    extends IntervalHEven
    implements EvictionRunEvent {
        int pagesToEvict;

        private EvictionRunHEvent(int pagesToEvict) {
            this.pagesToEvict = pagesToEvict;
        }

        public EvictionEvent beginEviction() {
            return LinearHistoryPageCacheTracer.this.add(new EvictionHEvent());
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", pagesToEvict:");
            out.print(this.pagesToEvict);
        }
    }

    public class UnmappedFileHEvent
    extends HEvent {
        File file;

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    public class MappedFileHEvent
    extends HEvent {
        File file;

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            this.print(out, this.file);
        }
    }

    public abstract class IntervalHEven
    extends HEvent {
        public void close() {
            LinearHistoryPageCacheTracer.this.add(new EndHEvent(this));
        }
    }

    public final class EndHEvent
    extends HEvent {
        IntervalHEven event;

        public EndHEvent(IntervalHEven event) {
            this.event = event;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", elapsedMicros:");
            out.print((this.time - this.event.time) / 1000L);
            out.print(", endOf:");
            Class<?> eventClass = this.event.getClass();
            String className = (String)LinearHistoryPageCacheTracer.this.classSimpleNameCache.get(eventClass);
            if (className == null) {
                className = eventClass.getSimpleName();
                LinearHistoryPageCacheTracer.this.classSimpleNameCache.put(eventClass, className);
            }
            out.print(className);
            out.print('#');
            out.print(System.identityHashCode(this.event));
        }
    }

    public abstract class HEvent {
        final long time = System.nanoTime();
        final long threadId;
        final String threadName;
        volatile HEvent prev;

        private HEvent() {
            Thread thread = Thread.currentThread();
            this.threadId = thread.getId();
            this.threadName = thread.getName();
            System.identityHashCode(this);
        }

        public final void print(PrintStream out, String exceptionLinePrefix) {
            if (this.getClass() == EndHEvent.class) {
                out.print('-');
            }
            out.print(this.getClass().getSimpleName());
            out.print('#');
            out.print(System.identityHashCode(this));
            out.print('[');
            out.print("time:");
            out.print((this.time - ((LinearHistoryPageCacheTracer)LinearHistoryPageCacheTracer.this).end.time) / 1000L);
            out.print(", threadId:");
            out.print(this.threadId);
            this.printBody(out, exceptionLinePrefix);
            out.print(']');
        }

        abstract void printBody(PrintStream var1, String var2);

        protected final void print(PrintStream out, File file) {
            out.print(", file:");
            out.print(file == null ? "<null>" : file.getPath());
        }

        protected final void print(PrintStream out, Throwable exception, String linePrefix) {
            if (exception != null) {
                out.println(", exception:");
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream sbuf = new PrintStream(buf);
                exception.printStackTrace(sbuf);
                sbuf.flush();
                BufferedReader reader = new BufferedReader(new StringReader(buf.toString()));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        out.print(linePrefix);
                        out.print('\t');
                        out.println(line);
                        line = reader.readLine();
                    }
                    out.print(linePrefix);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class SwitchableBufferedOutputStream
    extends BufferedOutputStream {
        public SwitchableBufferedOutputStream() {
            super(null);
        }

        public void setOut(OutputStream out) {
            this.out = out;
        }
    }
}

