/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;

public class ByteBuffers {
    private ByteBuffers() {
    }

    public static ByteBuffer allocate(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    public static ByteBuffer allocate(int capacity, ByteOrder order) {
        return ByteBuffer.allocate(capacity).order(order);
    }

    public static ByteBuffer allocate(int capacity, ByteUnit capacityUnit) {
        return ByteBuffer.allocate(Math.toIntExact(capacityUnit.toBytes(capacity)));
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return UnsafeUtil.allocateByteBuffer((int)capacity);
    }

    public static void releaseBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return;
        }
        UnsafeUtil.freeByteBuffer((ByteBuffer)byteBuffer);
    }
}

