/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class DefaultPageCacheTracer
implements PageCacheTracer {
    protected final LongAdder faults = new LongAdder();
    protected final LongAdder evictions = new LongAdder();
    protected final LongAdder pins = new LongAdder();
    protected final LongAdder unpins = new LongAdder();
    protected final LongAdder hits = new LongAdder();
    protected final LongAdder flushes = new LongAdder();
    protected final LongAdder bytesRead = new LongAdder();
    protected final LongAdder bytesWritten = new LongAdder();
    protected final LongAdder filesMapped = new LongAdder();
    protected final LongAdder filesUnmapped = new LongAdder();
    protected final LongAdder evictionExceptions = new LongAdder();
    protected final AtomicLong maxPages = new AtomicLong();
    private final FlushEvent flushEvent = new FlushEvent(){

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCacheTracer.this.bytesWritten.add(bytes);
        }

        @Override
        public void done() {
            DefaultPageCacheTracer.this.flushes.increment();
        }

        @Override
        public void done(IOException exception) {
            this.done();
        }

        @Override
        public void addPagesFlushed(int pageCount) {
        }
    };
    private final FlushEventOpportunity flushEventOpportunity = (filePageId, cachePageId, swapper) -> this.flushEvent;
    private final EvictionEvent evictionEvent = new EvictionEvent(){

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
        }

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheTracer.this.flushEventOpportunity;
        }

        @Override
        public void threwException(IOException exception) {
            DefaultPageCacheTracer.this.evictionExceptions.increment();
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }

        @Override
        public void close() {
            DefaultPageCacheTracer.this.evictions.increment();
        }
    };
    private final EvictionRunEvent evictionRunEvent = new EvictionRunEvent(){

        @Override
        public EvictionEvent beginEviction() {
            return DefaultPageCacheTracer.this.evictionEvent;
        }

        @Override
        public void close() {
        }
    };
    private final MajorFlushEvent majorFlushEvent = new MajorFlushEvent(){

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheTracer.this.flushEventOpportunity;
        }

        @Override
        public void close() {
        }
    };

    @Override
    public void mappedFile(File file) {
        this.filesMapped.increment();
    }

    @Override
    public void unmappedFile(File file) {
        this.filesUnmapped.increment();
    }

    @Override
    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.evictionRunEvent;
    }

    @Override
    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.majorFlushEvent;
    }

    @Override
    public MajorFlushEvent beginCacheFlush() {
        return this.majorFlushEvent;
    }

    @Override
    public long faults() {
        return this.faults.sum();
    }

    @Override
    public long evictions() {
        return this.evictions.sum();
    }

    @Override
    public long pins() {
        return this.pins.sum();
    }

    @Override
    public long unpins() {
        return this.unpins.sum();
    }

    @Override
    public long hits() {
        return this.hits.sum();
    }

    @Override
    public long flushes() {
        return this.flushes.sum();
    }

    @Override
    public long bytesRead() {
        return this.bytesRead.sum();
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten.sum();
    }

    @Override
    public long filesMapped() {
        return this.filesMapped.sum();
    }

    @Override
    public long filesUnmapped() {
        return this.filesUnmapped.sum();
    }

    @Override
    public long evictionExceptions() {
        return this.evictionExceptions.sum();
    }

    @Override
    public double hitRatio() {
        return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
    }

    @Override
    public double usageRatio() {
        return (double)(this.faults.sum() - this.evictions.sum()) / (double)this.maxPages.get();
    }

    @Override
    public void pins(long pins) {
        this.pins.add(pins);
    }

    @Override
    public void unpins(long unpins) {
        this.unpins.add(unpins);
    }

    @Override
    public void hits(long hits) {
        this.hits.add(hits);
    }

    @Override
    public void faults(long faults) {
        this.faults.add(faults);
    }

    @Override
    public void bytesRead(long bytesRead) {
        this.bytesRead.add(bytesRead);
    }

    @Override
    public void evictions(long evictions) {
        this.evictions.add(evictions);
    }

    @Override
    public void evictionExceptions(long evictionExceptions) {
        this.evictionExceptions.add(evictionExceptions);
    }

    @Override
    public void bytesWritten(long bytesWritten) {
        this.bytesWritten.add(bytesWritten);
    }

    @Override
    public void flushes(long flushes) {
        this.flushes.add(flushes);
    }

    @Override
    public void maxPages(long maxPages) {
        this.maxPages.set(maxPages);
    }
}

