/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.cursor;

import java.io.IOException;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultPageCursorTracer
implements PageCursorTracer {
    private long pins;
    private long unpins;
    private long hits;
    private long faults;
    private long bytesRead;
    private long bytesWritten;
    private long evictions;
    private long evictionExceptions;
    private long flushes;
    private PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
    private DefaultPinEvent pinTracingEvent = new DefaultPinEvent();
    private final EvictionEvent evictionEvent = new EvictionEvent(){

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
        }

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCursorTracer.this.flushEventOpportunity;
        }

        @Override
        public void threwException(IOException exception) {
            ++DefaultPageCursorTracer.this.evictionExceptions;
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.evictions;
        }
    };
    private final PageFaultEvent pageFaultEvent = new PageFaultEvent(){

        @Override
        public void addBytesRead(long bytes) {
            DefaultPageCursorTracer.this.bytesRead += bytes;
        }

        @Override
        public void done() {
            ++DefaultPageCursorTracer.this.faults;
        }

        @Override
        public void done(Throwable throwable) {
            this.done();
        }

        @Override
        public EvictionEvent beginEviction() {
            return DefaultPageCursorTracer.this.evictionEvent;
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }
    };
    private final FlushEventOpportunity flushEventOpportunity = new FlushEventOpportunity(){

        @Override
        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper) {
            return DefaultPageCursorTracer.this.flushEvent;
        }
    };
    private final FlushEvent flushEvent = new FlushEvent(){

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCursorTracer.this.bytesWritten += bytes;
        }

        @Override
        public void done() {
            ++DefaultPageCursorTracer.this.flushes;
        }

        @Override
        public void done(IOException exception) {
            this.done();
        }

        @Override
        public void addPagesFlushed(int pageCount) {
        }
    };

    @Override
    public void init(PageCacheTracer pageCacheTracer) {
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    public void reportEvents() {
        if (this.pins > 0L) {
            this.pageCacheTracer.pins(this.pins);
        }
        if (this.unpins > 0L) {
            this.pageCacheTracer.unpins(this.unpins);
        }
        if (this.hits > 0L) {
            this.pageCacheTracer.hits(this.hits);
        }
        if (this.faults > 0L) {
            this.pageCacheTracer.faults(this.faults);
        }
        if (this.bytesRead > 0L) {
            this.pageCacheTracer.bytesRead(this.bytesRead);
        }
        if (this.evictions > 0L) {
            this.pageCacheTracer.evictions(this.evictions);
        }
        if (this.evictionExceptions > 0L) {
            this.pageCacheTracer.evictionExceptions(this.evictionExceptions);
        }
        if (this.bytesWritten > 0L) {
            this.pageCacheTracer.bytesWritten(this.bytesWritten);
        }
        if (this.flushes > 0L) {
            this.pageCacheTracer.flushes(this.flushes);
        }
        this.reset();
    }

    private void reset() {
        this.pins = 0L;
        this.unpins = 0L;
        this.hits = 0L;
        this.faults = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.evictions = 0L;
        this.evictionExceptions = 0L;
        this.flushes = 0L;
    }

    @Override
    public long faults() {
        return this.faults;
    }

    @Override
    public long pins() {
        return this.pins;
    }

    @Override
    public long unpins() {
        return this.unpins;
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long bytesRead() {
        return this.bytesRead;
    }

    @Override
    public long evictions() {
        return this.evictions;
    }

    @Override
    public long evictionExceptions() {
        return this.evictionExceptions;
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long flushes() {
        return this.flushes;
    }

    @Override
    public double hitRatio() {
        return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
    }

    @Override
    public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
        ++this.pins;
        this.pinTracingEvent.eventHits = 1;
        return this.pinTracingEvent;
    }

    private class DefaultPinEvent
    implements PinEvent {
        int eventHits = 1;

        private DefaultPinEvent() {
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }

        @Override
        public PageFaultEvent beginPageFault() {
            this.eventHits = 0;
            return DefaultPageCursorTracer.this.pageFaultEvent;
        }

        @Override
        public void hit() {
            DefaultPageCursorTracer.this.hits += (long)this.eventHits;
        }

        @Override
        public void done() {
            ++DefaultPageCursorTracer.this.unpins;
        }
    }
}

