/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.impl.ConfigurationBean;
import org.neo4j.jmx.impl.KernelBean;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;

public final class JmxExtension
extends KernelExtension<JmxData> {
    public static final String KEY = "kernel jmx";
    private static final Logger log = Logger.getLogger(JmxExtension.class.getName());

    public JmxExtension() {
        super(KEY);
    }

    protected JmxData load(KernelData kernel) {
        Neo4jMBean bean;
        ManagementSupport support = ManagementSupport.load();
        MBeanServer mbs = support.getMBeanServer();
        LinkedList<Neo4jMBean> beans = new LinkedList<Neo4jMBean>();
        try {
            bean = new KernelBean(kernel, support);
            mbs.registerMBean(bean, bean.objectName);
            beans.add(bean);
        }
        catch (Exception e) {
            log.info("Failed to register Kernel JMX Bean");
        }
        for (ManagementBeanProvider provider : Service.load(ManagementBeanProvider.class)) {
            try {
                for (Neo4jMBean neo4jMBean : provider.loadBeans(kernel, support)) {
                    mbs.registerMBean(neo4jMBean, neo4jMBean.objectName);
                    beans.add(neo4jMBean);
                }
            }
            catch (Exception e) {
                log.info("Failed to register JMX Bean " + (Object)((Object)provider) + " (" + e + ")");
            }
        }
        try {
            bean = new ConfigurationBean(kernel, support);
            mbs.registerMBean(bean, bean.objectName);
            beans.add(bean);
        }
        catch (Exception e) {
            log.info("Failed to register Configuration JMX Bean");
        }
        return new JmxData(kernel, support, beans.toArray(new Neo4jMBean[beans.size()]));
    }

    protected void unload(JmxData data) {
        data.shutdown();
    }

    public JMXServiceURL getConnectionURL(KernelData kernel) {
        return ((JmxData)this.getState(kernel)).url;
    }

    public static final class JmxData {
        private final Neo4jMBean[] beans;
        private final JMXServiceURL url;
        private final ManagementSupport support;

        private JmxData(KernelData kernel, ManagementSupport support, Neo4jMBean[] beans) {
            this.support = support;
            this.beans = beans;
            this.url = support.getJMXServiceURL(kernel);
        }

        void shutdown() {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            for (Neo4jMBean bean : this.beans) {
                try {
                    mbs.unregisterMBean(bean.objectName);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to unregister JMX Bean " + bean, e);
                }
            }
        }

        public <T> Collection<T> getManagementBeans(Class<T> beanInterface) {
            Collection<Object> result = null;
            if (this.support.getClass() != ManagementSupport.class && this.beans.length > 0 && this.beans[0] instanceof KernelBean) {
                try {
                    result = this.support.getProxiesFor(beanInterface, (KernelBean)this.beans[0]);
                }
                catch (UnsupportedOperationException ignore) {
                    result = null;
                }
            }
            if (result == null) {
                result = new ArrayList();
                for (Neo4jMBean bean : this.beans) {
                    if (!beanInterface.isInstance(bean)) continue;
                    result.add(beanInterface.cast(bean));
                }
            }
            return result;
        }
    }
}

