/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

public enum PrivilegeAction {
    ACCESS,
    TRAVERSE,
    READ,
    WRITE,
    EXECUTE,
    CREATE_LABEL,
    CREATE_RELTYPE,
    CREATE_PROPERTYKEY,
    CREATE_INDEX,
    DROP_INDEX,
    CREATE_CONSTRAINT,
    DROP_CONSTRAINT,
    START_DATABASE,
    STOP_DATABASE,
    SHOW_TRANSACTION,
    KILL_TRANSACTION,
    SHOW_CONNECTION,
    KILL_CONNECTION,
    CREATE_DATABASE,
    DROP_DATABASE,
    SHOW_USER,
    CREATE_USER,
    ALTER_USER,
    DROP_USER,
    SHOW_ROLE,
    CREATE_ROLE,
    DROP_ROLE,
    ASSIGN_ROLE,
    REMOVE_ROLE,
    SHOW_PRIVILEGE,
    GRANT_PRIVILEGE,
    DENY_PRIVILEGE,
    REVOKE_PRIVILEGE,
    ADMIN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return USER_MANAGEMENT.satisfies(action) || ROLE_MANAGEMENT.satisfies(action) || PRIVILEGE_MANAGEMENT.satisfies(action) || TRANSACTION_MANAGEMENT.satisfies(action) || DATABASE_MANAGEMENT.satisfies(action) || this == action;
        }
    }
    ,
    TOKEN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_LABEL: 
                case CREATE_RELTYPE: 
                case CREATE_PROPERTYKEY: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    SCHEMA{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return INDEX.satisfies(action) || CONSTRAINT.satisfies(action) || this == action;
        }
    }
    ,
    CONSTRAINT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_CONSTRAINT: 
                case DROP_CONSTRAINT: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    INDEX{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_INDEX: 
                case DROP_INDEX: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    DATABASE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_DATABASE: 
                case DROP_DATABASE: 
                case START_DATABASE: 
                case STOP_DATABASE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    TRANSACTION_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_TRANSACTION: 
                case KILL_TRANSACTION: 
                case SHOW_CONNECTION: 
                case KILL_CONNECTION: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    USER_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_USER: 
                case CREATE_USER: 
                case ALTER_USER: 
                case DROP_USER: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    ROLE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_ROLE: 
                case CREATE_ROLE: 
                case DROP_ROLE: 
                case ASSIGN_ROLE: 
                case REMOVE_ROLE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    PRIVILEGE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_PRIVILEGE: 
                case GRANT_PRIVILEGE: 
                case DENY_PRIVILEGE: 
                case REVOKE_PRIVILEGE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    GRAPH_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case READ: 
                case WRITE: 
                case TRAVERSE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    DATABASE_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case ACCESS: 
                case EXECUTE: {
                    return true;
                }
            }
            return SCHEMA.satisfies(action) || TOKEN.satisfies(action) || GRAPH_ACTIONS.satisfies(action) || this == action;
        }
    };


    public boolean satisfies(PrivilegeAction action) {
        return this == action;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static PrivilegeAction from(String name) {
        try {
            return PrivilegeAction.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

