/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.internal.kernel.api;

/**
 * An index result, typically in the form of a cursor, that can have a score for how well the current or given result matches the query.
 */
public interface IndexResultScore
{
    /**
     * @return the score, if any, that signifies how well the current node matches the query. If there is no score associated with the match,
     * then {@link Float#NaN} is returned. Also, if the cursor has been exhausted, or the cursor is otherwise not placed at a node,
     * then {@link Float#NaN} is also returned.
     */
    float score();
}
