/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Collections;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.kernel.api.exceptions.Status;

public interface AccessMode {
    public boolean allowsWrites();

    public boolean allowsTokenCreates(PrivilegeAction var1);

    public boolean allowsSchemaWrites();

    public boolean allowsSchemaWrites(PrivilegeAction var1);

    public boolean allowsShowIndex();

    public boolean allowsShowConstraint();

    public boolean allowsTraverseAllLabels();

    public boolean allowsTraverseAllNodesWithLabel(long var1);

    public boolean disallowsTraverseLabel(long var1);

    public boolean allowsTraverseNode(long ... var1);

    public boolean allowsTraverseAllRelTypes();

    public boolean allowsTraverseRelType(int var1);

    public boolean allowsReadPropertyAllLabels(int var1);

    public boolean disallowsReadPropertyForSomeLabel(int var1);

    public boolean allowsReadNodeProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsReadPropertyAllRelTypes(int var1);

    public boolean allowsReadRelationshipProperty(IntSupplier var1, int var2);

    public boolean allowsSeePropertyKeyToken(int var1);

    @Deprecated
    public boolean shouldBoostAccessForProcedureWith(String[] var1);

    public boolean allowsExecuteProcedure(int var1);

    public boolean shouldBoostProcedure(int var1);

    public boolean allowsExecuteFunction(int var1);

    public boolean shouldBoostFunction(int var1);

    public boolean allowsExecuteAggregatingFunction(int var1);

    public boolean shouldBoostAggregatingFunction(int var1);

    public boolean allowsSetLabel(long var1);

    public boolean allowsRemoveLabel(long var1);

    public boolean allowsCreateNode(int[] var1);

    public boolean allowsDeleteNode(Supplier<TokenSet> var1);

    public boolean allowsCreateRelationship(int var1);

    public boolean allowsDeleteRelationship(int var1);

    public boolean allowsSetProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsSetProperty(IntSupplier var1, int var2);

    public AuthorizationViolationException onViolation(String var1);

    public String name();

    default public Set<String> roles() {
        return Collections.emptySet();
    }

    default public boolean isOverridden() {
        return false;
    }

    public static enum Static implements AccessMode
    {
        ACCESS(false, false, false, false, false),
        CREDENTIALS_EXPIRED(false, false, false, false, false){

            @Override
            public AuthorizationViolationException onViolation(String msg) {
                return new AuthorizationViolationException(String.format(msg + "%n%nThe credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nChanging your password is easy to do via the Neo4j Browser.%nIf you are connecting via a shell or programmatically via a driver, just issue a `ALTER CURRENT USER SET PASSWORD FROM 'current password' TO 'new password'` statement against the system database in the current session, and then restart your driver with the new password configured.", new Object[0]), (Status)Status.Security.CredentialsExpired);
            }
        }
        ,
        READ(true, false, false, false, false),
        WRITE_ONLY(false, true, false, false, false),
        WRITE(true, true, false, false, false),
        TOKEN_WRITE(true, true, true, false, false),
        SCHEMA(true, true, true, true, false),
        FULL(true, true, true, true, true);

        private final boolean read;
        private final boolean write;
        private final boolean token;
        private final boolean schema;
        private final boolean procedureBoost;

        private Static(boolean read, boolean write, boolean token, boolean schema, boolean procedureBoost) {
            this.read = read;
            this.write = write;
            this.token = token;
            this.schema = schema;
            this.procedureBoost = procedureBoost;
        }

        @Override
        public boolean allowsWrites() {
            return this.write;
        }

        @Override
        public boolean allowsTokenCreates(PrivilegeAction action) {
            return this.token;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return this.schema;
        }

        @Override
        public boolean allowsSchemaWrites(PrivilegeAction action) {
            return this.schema;
        }

        @Override
        public boolean allowsShowIndex() {
            return this.schema;
        }

        @Override
        public boolean allowsShowConstraint() {
            return this.schema;
        }

        @Override
        public boolean allowsTraverseAllLabels() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseAllNodesWithLabel(long label) {
            return this.read;
        }

        @Override
        public boolean disallowsTraverseLabel(long label) {
            return false;
        }

        @Override
        public boolean allowsTraverseNode(long ... labels) {
            return this.read;
        }

        @Override
        public boolean allowsTraverseAllRelTypes() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseRelType(int relType) {
            return this.read;
        }

        @Override
        public boolean allowsReadPropertyAllLabels(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
            return false;
        }

        @Override
        public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelationshipProperty(IntSupplier relType, int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsSeePropertyKeyToken(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean shouldBoostAccessForProcedureWith(String[] allowed) {
            return this.procedureBoost;
        }

        @Override
        public boolean allowsExecuteProcedure(int procedureId) {
            return true;
        }

        @Override
        public boolean shouldBoostProcedure(int procedureId) {
            return this.procedureBoost;
        }

        @Override
        public boolean allowsExecuteFunction(int id) {
            return true;
        }

        @Override
        public boolean shouldBoostFunction(int id) {
            return this.procedureBoost;
        }

        @Override
        public boolean allowsExecuteAggregatingFunction(int id) {
            return true;
        }

        @Override
        public boolean shouldBoostAggregatingFunction(int id) {
            return this.procedureBoost;
        }

        @Override
        public boolean allowsSetLabel(long labelId) {
            return this.write;
        }

        @Override
        public boolean allowsRemoveLabel(long labelId) {
            return this.write;
        }

        @Override
        public boolean allowsCreateNode(int[] labelIds) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
            return this.write;
        }

        @Override
        public boolean allowsCreateRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(IntSupplier relType, int propertyKey) {
            return this.write;
        }

        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return new AuthorizationViolationException(msg);
        }
    }
}

