/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;

public final class StoreId {
    public static final int SIZE_IN_BYTES = 24;
    private static final long storeVersionAsLong = 13843131341501958L;
    private static final Random r = new SecureRandom();
    private final long creationTime;
    private final long randomId;

    public StoreId() {
        this(System.currentTimeMillis(), r.nextLong());
    }

    public StoreId(long creationTime, long randomId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoreId) {
            StoreId that = (StoreId)obj;
            return that.creationTime == this.creationTime && that.randomId == this.randomId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.creationTime ^ this.randomId);
    }

    public byte[] serialize() {
        return ByteBuffer.wrap(new byte[24]).putLong(this.creationTime).putLong(this.randomId).putLong(13843131341501958L).array();
    }

    public String toString() {
        return "StoreId[time:" + this.creationTime + ", id:" + this.randomId + ", store version: " + -2 + "]";
    }

    public static StoreId deserialize(byte[] data) {
        assert (data.length == 24) : "unexpected data";
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return StoreId.deserialize(buffer);
    }

    public static StoreId deserialize(ByteBuffer buffer) {
        long creationTime = buffer.getLong();
        long randomId = buffer.getLong();
        buffer.getLong();
        return new StoreId(creationTime, randomId);
    }
}

