/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.neo4j.function.Function;
import org.neo4j.helpers.ObjectUtil;

public abstract class ArrayUtil {
    public static final ArrayEquality DEFAULT_ARRAY_EQUALITY = new ArrayEquality(){

        @Override
        public boolean typeEquals(Class<?> firstType, Class<?> otherType) {
            return firstType == otherType;
        }

        @Override
        public boolean itemEquals(Object lhs, Object rhs) {
            return lhs == rhs || lhs != null && lhs.equals(rhs);
        }
    };

    @Deprecated
    public static String toString(Object array) {
        assert (array.getClass().isArray()) : array + " is not an array";
        return ObjectUtil.arrayToString(array);
    }

    public static int hashCode(Object array) {
        int length;
        assert (array.getClass().isArray()) : array + " is not an array";
        int result = length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            result = 31 * result + Array.get(array, i).hashCode();
        }
        return result;
    }

    public static boolean equals(Object firstArray, Object otherArray) {
        return ArrayUtil.equals(firstArray, otherArray, DEFAULT_ARRAY_EQUALITY);
    }

    public static boolean equals(Object firstArray, Object otherArray, ArrayEquality equality) {
        int length;
        assert (firstArray.getClass().isArray()) : firstArray + " is not an array";
        assert (otherArray.getClass().isArray()) : otherArray + " is not an array";
        if (equality.typeEquals(firstArray.getClass(), otherArray.getClass()) && (length = Array.getLength(firstArray)) == Array.getLength(otherArray)) {
            for (int i = 0; i < length; ++i) {
                if (equality.itemEquals(Array.get(firstArray, i), Array.get(otherArray, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object clone(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        throw new IllegalArgumentException("Not an array type: " + array.getClass());
    }

    public static boolean approximatelyEqual(double[] that, double[] other, double tolerance) {
        if (that == other) {
            return true;
        }
        if (null == that || null == other) {
            return false;
        }
        if (that.length != other.length) {
            return false;
        }
        for (int i = 0; i < that.length; ++i) {
            if (!(Math.abs(other[i] - that[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static <T> int missing(T[] array, T[] contains) {
        int missing = 0;
        for (T check : contains) {
            if (ArrayUtil.contains(array, check)) continue;
            ++missing;
        }
        return missing;
    }

    public static <T> boolean containsAll(T[] array, T[] contains) {
        for (T check : contains) {
            if (ArrayUtil.contains(array, check)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T[] array, T contains) {
        return ArrayUtil.contains(array, array.length, contains);
    }

    public static <T> boolean contains(T[] array, int arrayLength, T contains) {
        for (int i = 0; i < arrayLength; ++i) {
            T item = array[i];
            if (!ArrayUtil.nullSafeEquals(item, contains)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean nullSafeEquals(T first, T other) {
        return first == null ? first == other : first.equals(other);
    }

    public static <T> T[] union(T[] first, T[] other) {
        if (first == null || other == null) {
            return first == null ? other : first;
        }
        int missing = ArrayUtil.missing(first, other);
        if (missing == 0) {
            return first;
        }
        T[] union = Arrays.copyOf(first, first.length + missing);
        int cursor = first.length;
        for (T candidate : other) {
            if (ArrayUtil.contains(first, candidate)) continue;
            union[cursor++] = candidate;
            --missing;
        }
        assert (missing == 0);
        return union;
    }

    public static <T> String join(T[] items, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            builder.append(i > 0 ? delimiter : "").append(items[i]);
        }
        return builder.toString();
    }

    public static <FROM, TO> TO[] map(FROM[] from, Function<FROM, TO> transformer, Class<TO> toClass) {
        Object[] result = (Object[])Array.newInstance(toClass, from.length);
        for (int i = 0; i < from.length; ++i) {
            result[i] = transformer.apply(from[i]);
        }
        return result;
    }

    public static <T> T[] concat(T first, T ... additional) {
        Object[] result = (Object[])Array.newInstance(additional.getClass().getComponentType(), additional.length + 1);
        result[0] = first;
        System.arraycopy(additional, 0, result, 1, additional.length);
        return result;
    }

    private ArrayUtil() {
    }

    public static interface ArrayEquality {
        public boolean typeEquals(Class<?> var1, Class<?> var2);

        public boolean itemEquals(Object var1, Object var2);
    }
}

