/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class DatabaseAvailability
implements Lifecycle,
AvailabilityGuard.AvailabilityRequirement {
    private final AvailabilityGuard availabilityGuard;
    private final TransactionCounters transactionMonitor;
    private final long awaitActiveTransactionDeadlineMillis;

    public DatabaseAvailability(AvailabilityGuard availabilityGuard, TransactionCounters transactionMonitor) {
        this(availabilityGuard, transactionMonitor, TimeUnit.SECONDS.toMillis(10L));
    }

    public DatabaseAvailability(AvailabilityGuard availabilityGuard, TransactionCounters transactionMonitor, long awaitActiveTransactionDeadlineMillis) {
        this.availabilityGuard = availabilityGuard;
        this.transactionMonitor = transactionMonitor;
        this.awaitActiveTransactionDeadlineMillis = awaitActiveTransactionDeadlineMillis;
        availabilityGuard.deny(this);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.availabilityGuard.grant(this);
    }

    @Override
    public void stop() throws Throwable {
        this.availabilityGuard.deny(this);
        this.awaitTransactionsClosedWithinTimeout();
    }

    private void awaitTransactionsClosedWithinTimeout() {
        long deadline = Clock.SYSTEM_CLOCK.currentTimeMillis() + this.awaitActiveTransactionDeadlineMillis;
        while (this.transactionMonitor.getNumberOfActiveTransactions() > 0L && Clock.SYSTEM_CLOCK.currentTimeMillis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public String description() {
        return "Database is stopped";
    }
}

