/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategy;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class KernelExtensions
extends DependencyResolver.Adapter
implements Lifecycle {
    private final List<KernelExtensionFactory<?>> kernelExtensionFactories;
    private final DependencyResolver dependencyResolver;
    private final LifeSupport life = new LifeSupport();
    private final UnsatisfiedDependencyStrategy unsatisfiedDepencyStrategy;

    public KernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, DependencyResolver dependencyResolver, UnsatisfiedDependencyStrategy unsatisfiedDepencyStrategy) {
        this.unsatisfiedDepencyStrategy = unsatisfiedDepencyStrategy;
        this.kernelExtensionFactories = Iterables.addAll(new ArrayList(), kernelExtensionFactories);
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public void init() throws Throwable {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            Object configuration = this.getKernelExtensionDependencies(kernelExtensionFactory);
            try {
                this.life.add(kernelExtensionFactory.newKernelExtension(configuration));
            }
            catch (UnsatisfiedDependencyException e) {
                this.unsatisfiedDepencyStrategy.handle(kernelExtensionFactory, e);
            }
        }
        this.life.init();
    }

    @Override
    public void start() throws Throwable {
        this.life.start();
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public boolean isRegistered(Class<?> kernelExtensionFactoryClass) {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            if (!kernelExtensionFactoryClass.isInstance(kernelExtensionFactory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
        Iterable<Lifecycle> filtered = Iterables.filter(new TypeFilter<T>(type), this.life.getLifecycleInstances());
        Iterable casted = Iterables.map(new CastFunction<T>(type), filtered);
        return selector.select(type, casted);
    }

    private Object getKernelExtensionDependencies(KernelExtensionFactory<?> factory) {
        Class configurationClass = (Class)((ParameterizedType)factory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return Proxy.newProxyInstance(configurationClass.getClassLoader(), new Class[]{configurationClass}, (InvocationHandler)new KernelExtensionHandler());
    }

    public Iterable<KernelExtensionFactory<?>> listFactories() {
        return this.kernelExtensionFactories;
    }

    private class CastFunction<T>
    implements Function<Object, T> {
        private final Class<T> type;

        public CastFunction(Class<T> type) {
            this.type = type;
        }

        public T apply(Object o) {
            return this.type.cast(o);
        }
    }

    private class KernelExtensionHandler
    implements InvocationHandler {
        private KernelExtensionHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return KernelExtensions.this.dependencyResolver.resolveDependency(method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw new UnsatisfiedDependencyException(e);
            }
        }
    }

    private static class TypeFilter<T>
    implements Predicate {
        private final Class<T> type;

        public TypeFilter(Class<T> type) {
            this.type = type;
        }

        public boolean accept(Object extension) {
            return this.type.isInstance(extension);
        }
    }
}

