/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.HitCounter;
import org.neo4j.kernel.impl.cache.ReferenceWithKey;
import org.neo4j.kernel.impl.cache.ReferenceWithKeyQueue;

public class ReferenceCache<E extends EntityWithSizeObject>
extends Cache.Adapter<E> {
    static final int MAX_NUM_PUT_BEFORE_POLL = 5000;
    private final ConcurrentHashMap<Long, ReferenceWithKey<Long, E>> cache = new ConcurrentHashMap();
    private final ReferenceWithKeyQueue<Long, E> refQueue = new ReferenceWithKeyQueue();
    private final String name;
    private final HitCounter hitCounter = new HitCounter();
    private final AtomicInteger putCounter = new AtomicInteger();
    private final ReferenceWithKey.Factory referenceFactory;

    ReferenceCache(String name, ReferenceWithKey.Factory referenceFactory) {
        this.name = name;
        this.referenceFactory = referenceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E put(E value, boolean force) {
        Long key = value.getId();
        ReferenceWithKey<Long, E> ref = this.referenceFactory.newReference(key, value, this.refQueue);
        try {
            block5: {
                EntityWithSizeObject prevValue;
                while (true) {
                    ReferenceWithKey<Long, E> previous;
                    ReferenceWithKey<Long, E> referenceWithKey = previous = force ? this.cache.put(key, ref) : this.cache.putIfAbsent(key, ref);
                    if (previous == null) break block5;
                    prevValue = (EntityWithSizeObject)previous.get();
                    if (prevValue != null) break;
                    this.pollClearedValues();
                }
                EntityWithSizeObject entityWithSizeObject = prevValue;
                return (E)entityWithSizeObject;
            }
            E e = value;
            return e;
        }
        finally {
            this.recordPutAndPollIfNeeded(1);
        }
    }

    @Override
    public void putAll(Collection<E> entities) {
        HashMap<Long, ReferenceWithKey<Long, EntityWithSizeObject>> softMap = new HashMap<Long, ReferenceWithKey<Long, EntityWithSizeObject>>(entities.size() * 2);
        for (EntityWithSizeObject entity : entities) {
            Long key = entity.getId();
            ReferenceWithKey<Long, EntityWithSizeObject> ref = this.referenceFactory.newReference(key, entity, this.refQueue);
            softMap.put(key, ref);
        }
        this.cache.putAll(softMap);
        this.recordPutAndPollIfNeeded(softMap.size());
    }

    @Override
    public E get(long key) {
        ReferenceWithKey<Long, E> ref = this.cache.get(key);
        if (ref != null) {
            EntityWithSizeObject value = (EntityWithSizeObject)ref.get();
            if (value != null) {
                return (E)this.hitCounter.count(value);
            }
            this.pollClearedValues();
        }
        return (E)((EntityWithSizeObject)this.hitCounter.count(null));
    }

    @Override
    public E remove(long key) {
        ReferenceWithKey<Long, E> ref = this.cache.remove(key);
        if (ref != null) {
            EntityWithSizeObject value = (EntityWithSizeObject)ref.get();
            if (value != null) {
                return (E)value;
            }
            this.pollClearedValues();
        }
        return null;
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long hitCount() {
        return this.hitCounter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.hitCounter.getMissCount();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateSize(E entity, int newSize) {
    }

    @Override
    public void printStatistics() {
    }

    private void recordPutAndPollIfNeeded(int elementsCount) {
        int count = this.putCounter.addAndGet(elementsCount);
        if (count > 5000) {
            this.pollClearedValues();
        }
    }

    private void pollClearedValues() {
        this.putCounter.set(0);
        ReferenceWithKey<Long, E> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key());
            clearedValue = this.refQueue.safePoll();
        }
    }
}

