/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Collections;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class PropertyUniqueConstraintDefinition
implements ConstraintDefinition {
    private final InternalSchemaActions actions;
    private final Label label;
    private final String propertyKey;

    public PropertyUniqueConstraintDefinition(InternalSchemaActions actions, Label label, String propertyKey) {
        this.actions = actions;
        this.label = label;
        this.propertyKey = propertyKey;
    }

    @Override
    public void drop() {
        this.assertInUnterminatedTransaction();
        this.actions.dropPropertyUniquenessConstraint(this.label, this.propertyKey);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return Collections.singletonList(this.propertyKey);
    }

    @Override
    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.label;
    }

    @Override
    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.UNIQUENESS;
    }

    @Override
    public boolean isConstraintType(ConstraintType type) {
        this.assertInUnterminatedTransaction();
        return this.getConstraintType().equals((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyUniqueConstraintDefinition that = (PropertyUniqueConstraintDefinition)o;
        if (!this.actions.equals(that.actions)) {
            return false;
        }
        if (!this.label.equals(that.label)) {
            return false;
        }
        return this.propertyKey.equals(that.propertyKey);
    }

    public int hashCode() {
        int result = this.actions.hashCode();
        result = 31 * result + this.label.name().hashCode();
        result = 31 * result + this.propertyKey.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s.%s IS UNIQUE", this.label.name().toLowerCase(), this.propertyKey);
    }

    private final void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }
}

