/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class KeyValueMerger
implements DataProvider {
    private final DataProvider first;
    private final DataProvider other;
    private final BigEndianByteArrayBuffer firstKey;
    private final BigEndianByteArrayBuffer firstValue;
    private final BigEndianByteArrayBuffer otherKey;
    private final BigEndianByteArrayBuffer otherValue;
    private boolean firstAvail;
    private boolean otherAvail;

    public KeyValueMerger(DataProvider first, DataProvider other, int keySize, int valueSize) throws IOException {
        this.first = first;
        this.firstKey = BigEndianByteArrayBuffer.buffer(keySize);
        this.firstValue = BigEndianByteArrayBuffer.buffer(valueSize);
        this.firstAvail = this.first.visit(this.firstKey, this.firstValue);
        this.other = other;
        this.otherKey = BigEndianByteArrayBuffer.buffer(keySize);
        this.otherValue = BigEndianByteArrayBuffer.buffer(valueSize);
        this.otherAvail = this.other.visit(this.otherKey, this.otherValue);
    }

    @Override
    public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
        if (this.firstAvail && this.otherAvail) {
            int cmp = this.firstKey.compareTo(this.otherKey.buffer);
            if (cmp < 0) {
                this.firstKey.read(key);
                this.firstValue.read(value);
                this.firstAvail = this.first.visit(this.firstKey, this.firstValue);
            } else {
                this.otherKey.read(key);
                this.otherValue.read(value);
                this.otherAvail = this.other.visit(this.otherKey, this.otherValue);
                if (cmp == 0) {
                    this.firstAvail = this.first.visit(this.firstKey, this.firstValue);
                }
            }
            return true;
        }
        if (this.firstAvail) {
            this.firstKey.read(key);
            this.firstValue.read(value);
            this.firstAvail = this.first.visit(this.firstKey, this.firstValue);
            return true;
        }
        if (this.otherAvail) {
            this.otherKey.read(key);
            this.otherValue.read(value);
            this.otherAvail = this.other.visit(this.otherKey, this.otherValue);
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        try (DataProvider ignored = this.other;){
            this.first.close();
        }
    }
}

