/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;

public class SchemaIndexMigrator
implements StoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final UpgradableDatabase upgradableDatabase;
    private final SchemaStoreProvider schemaStoreProvider;
    private String versionToUpgradeFrom;

    public SchemaIndexMigrator(FileSystemAbstraction fileSystem, UpgradableDatabase upgradableDatabase, SchemaStoreProvider schemaStoreProvider) {
        this.fileSystem = fileSystem;
        this.upgradableDatabase = upgradableDatabase;
        this.schemaStoreProvider = schemaStoreProvider;
    }

    @Override
    public boolean needsMigration(File storeDir) throws IOException {
        if (this.upgradableDatabase.hasCurrentVersion(this.fileSystem, storeDir)) {
            return false;
        }
        switch (this.versionToUpgradeFrom(storeDir)) {
            case "v0.A.0": {
                return false;
            }
            case "v0.A.1": 
            case "v0.A.3": {
                return true;
            }
        }
        throw new IllegalStateException("Unknown version to upgrade from: " + this.versionToUpgradeFrom(storeDir));
    }

    @Override
    public void migrate(File storeDir, File migrationDir, SchemaIndexProvider schemaIndexProvider, PageCache pageCache) throws IOException {
        switch (this.versionToUpgradeFrom(storeDir)) {
            case "v0.A.1": 
            case "v0.A.3": {
                this.deleteIndexesContainingArrayValues(storeDir, pageCache, schemaIndexProvider);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + this.versionToUpgradeFrom(storeDir));
            }
        }
    }

    private void deleteIndexesContainingArrayValues(File storeDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider) throws IOException {
        File indexRoot = SchemaIndexProvider.getRootDirectory(storeDir, schemaIndexProvider.getProviderDescriptor().getKey());
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(new Config());
        ArrayList<File> indexesToBeDeleted = new ArrayList<File>();
        try (SchemaStore schema = this.schemaStoreProvider.provide(storeDir, pageCache);){
            Iterator<SchemaRule> rules = schema.loadAllSchemaRules();
            while (rules.hasNext()) {
                SchemaRule rule = rules.next();
                IndexConfiguration indexConfig = new IndexConfiguration(rule.getKind() == SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
                IndexAccessor accessor = schemaIndexProvider.getOnlineAccessor(rule.getId(), indexConfig, samplingConfig);
                Throwable throwable = null;
                try {
                    IndexReader reader = accessor.newReader();
                    Throwable throwable2 = null;
                    try {
                        if (!reader.valueTypesInIndex().contains(Array.class)) continue;
                        indexesToBeDeleted.add(new File(indexRoot, "" + rule.getId()));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (accessor == null) continue;
                    if (throwable != null) {
                        try {
                            accessor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    accessor.close();
                }
            }
        }
        for (File index : indexesToBeDeleted) {
            this.fileSystem.deleteRecursively(index);
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir) throws IOException {
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
    }

    @Override
    public void close() {
    }

    private String versionToUpgradeFrom(File storeDir) {
        if (this.versionToUpgradeFrom == null) {
            this.versionToUpgradeFrom = this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return this.versionToUpgradeFrom;
    }

    public static interface SchemaStoreProvider {
        public SchemaStore provide(File var1, PageCache var2);
    }
}

