/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRelationshipCountsDataStep
extends IoProducerStep {
    private final RelationshipStore store;
    private final RelationshipRecord record = new RelationshipRecord(-1L);
    private final long highestId;
    private long id = -1L;

    public ReadRelationshipCountsDataStep(StageControl control, Configuration config, RelationshipStore store) {
        super(control, config);
        this.store = store;
        this.highestId = store.getHighestPossibleIdInUse();
    }

    protected long[] nextBatchOrNull(long ticket, int batchSize) {
        if (this.id >= this.highestId) {
            return null;
        }
        long[] batch = new long[batchSize * 3];
        int i = 0;
        while (i < batchSize && ++this.id <= this.highestId) {
            if (!this.store.fillRecord(this.id, this.record, RecordLoad.CHECK)) continue;
            int index = i++ * 3;
            batch[index++] = this.record.getFirstNode();
            batch[index++] = this.record.getType();
            batch[index++] = this.record.getSecondNode();
        }
        return i == batchSize ? batch : Arrays.copyOf(batch, i * 3);
    }

    @Override
    protected long position() {
        return this.doneBatches.get() * (long)this.batchSize * 34L;
    }
}

