/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.function.Function;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoQueue;

public class WriterFactories {
    public static Function<Configuration, BatchingPageCache.WriterFactory> parallel() {
        return new Function<Configuration, BatchingPageCache.WriterFactory>(){

            public BatchingPageCache.WriterFactory apply(Configuration configuration) {
                return new IoQueue(1, configuration.maxNumberOfIoProcessors(), configuration.workAheadSize() * 10, BatchingPageCache.SYNCHRONOUS);
            }
        };
    }

    public static abstract class SingleThreadedWriterFactory
    implements BatchingPageCache.WriterFactory {
        @Override
        public int numberOfProcessors() {
            return 1;
        }

        @Override
        public boolean incrementNumberOfProcessors() {
            return false;
        }

        @Override
        public boolean decrementNumberOfProcessors() {
            return false;
        }
    }
}

