/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;

public class DenseNodeIT {
    @Rule
    public ImpermanentDatabaseRule databaseRule = new ImpermanentDatabaseRule();

    @Test
    public void testBringingNodeOverDenseThresholdIsConsistent() throws Exception {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode(db, root, 40);
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            this.createRelationshipsOnNode(db, root, 60);
            Assert.assertEquals((long)100L, (long)root.getDegree());
            Assert.assertEquals((long)100L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable x2) {
            var4_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)100L, (long)root.getDegree());
            Assert.assertEquals((long)100L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)root.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void deletingRelationshipsFromDenseNodeIsConsistent() throws Exception {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode(db, root, 100);
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            this.deleteRelationshipsFromNode(root, 80);
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable x2) {
            var4_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() throws Exception {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode(db, root, 100);
            this.deleteRelationshipsFromNode(root, 80);
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testBringingTwoConnectedNodesOverDenseThresholdIsConsistent() throws Exception {
        Node sink;
        Node source;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            source = db.createNode();
            sink = db.createNode();
            this.createRelationshipsBetweenNodes(source, sink, 40);
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            this.createRelationshipsBetweenNodes(source, sink, 60);
            Assert.assertEquals((long)100L, (long)source.getDegree());
            Assert.assertEquals((long)100L, (long)source.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)source.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            Assert.assertEquals((long)100L, (long)sink.getDegree());
            Assert.assertEquals((long)0L, (long)sink.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)100L, (long)sink.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable x2) {
            var5_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            Assert.assertEquals((long)100L, (long)source.getDegree());
            Assert.assertEquals((long)100L, (long)source.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)source.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)source.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            Assert.assertEquals((long)100L, (long)sink.getDegree());
            Assert.assertEquals((long)0L, (long)sink.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)100L, (long)sink.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)sink.getDegree((RelationshipType)DynamicRelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void deleteRelationshipsFromNode(Node root, int numberOfRelationships) {
        int deleted = 0;
        for (Relationship relationship : root.getRelationships()) {
            relationship.delete();
            if (++deleted != numberOfRelationships) continue;
            break;
        }
    }

    private void createRelationshipsOnNode(GraphDatabaseAPI db, Node root, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            root.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }

    private void createRelationshipsBetweenNodes(Node source, Node sink, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            source.createRelationshipTo(sink, (RelationshipType)DynamicRelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }
}

