/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.ProcessFailureException;
import org.neo4j.helpers.progress.Completion;
import org.neo4j.helpers.progress.Indicator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.test.Mute;

public class ProgressMonitorTest {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EXPECTED_TEXTUAL_OUTPUT;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public final SingleIndicator factory = new SingleIndicator();

    @Test
    public void shouldReportProgressInTheSpecifiedIntervals() throws Exception {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressListener progressListener = this.factory.mock(indicator, 10).singlePart(this.testName.getMethodName(), 16L);
        progressListener.started();
        for (int i = 0; i < 16; ++i) {
            progressListener.add(1L);
        }
        progressListener.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(16L);
        for (int i = 0; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAggregateProgressFromMultipleProcesses() throws Exception {
        int i;
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener first = builder.progressForPart("first", 5L);
        ProgressListener other = builder.progressForPart("other", 5L);
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(10L);
        order.verifyNoMoreInteractions();
        first.started();
        for (i = 0; i < 5; ++i) {
            first.add(1L);
        }
        first.done();
        ((Indicator)order.verify((Object)indicator)).startPart("first", 5L);
        for (i = 0; i < 5; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("first");
        order.verifyNoMoreInteractions();
        other.started();
        for (i = 0; i < 5; ++i) {
            other.add(1L);
        }
        other.done();
        ((Indicator)order.verify((Object)indicator)).startPart("other", 5L);
        for (i = 5; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("other");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldNotAllowAddingPartsAfterCompletingMultiPartBuilder() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(ProgressMonitorTest.indicatorMock(), 10).multipleParts(this.testName.getMethodName());
        builder.progressForPart("first", 10L);
        builder.build();
        try {
            builder.progressForPart("other", 10L);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Builder has been completed.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowAddingMultiplePartsWithSameIdentifier() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = ((ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class)).multipleParts(this.testName.getMethodName());
        builder.progressForPart("first", 10L);
        try {
            builder.progressForPart("first", 10L);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"Part 'first' has already been defined.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldStartProcessAutomaticallyIfNotDoneBefore() throws Exception {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressListener progressListener = this.factory.mock(indicator, 10).singlePart(this.testName.getMethodName(), 16L);
        for (int i = 0; i < 16; ++i) {
            progressListener.add(1L);
        }
        progressListener.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator, Mockito.times((int)1))).startProcess(16L);
        for (int i = 0; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldStartMultiPartProcessAutomaticallyIfNotDoneBefore() throws Exception {
        int i;
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener first = builder.progressForPart("first", 5L);
        ProgressListener other = builder.progressForPart("other", 5L);
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(10L);
        order.verifyNoMoreInteractions();
        for (i = 0; i < 5; ++i) {
            first.add(1L);
        }
        first.done();
        ((Indicator)order.verify((Object)indicator)).startPart("first", 5L);
        for (i = 0; i < 5; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("first");
        order.verifyNoMoreInteractions();
        for (i = 0; i < 5; ++i) {
            other.add(1L);
        }
        other.done();
        ((Indicator)order.verify((Object)indicator)).startPart("other", 5L);
        for (i = 5; i < 10; ++i) {
            ((Indicator)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator)order.verify((Object)indicator)).completePart("other");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldCompleteMultiPartProgressWithNoPartsImmediately() throws Exception {
        Indicator indicator = ProgressMonitorTest.indicatorMock();
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        builder.build();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startProcess(0L);
        ((Indicator)order.verify((Object)indicator)).progress(0, 10);
        ((Indicator)order.verify((Object)indicator)).completeProcess();
        order.verifyNoMoreInteractions();
    }

    private static Indicator indicatorMock() {
        Indicator indicator = (Indicator)Mockito.mock(Indicator.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((Indicator)Mockito.doNothing().when((Object)indicator)).progress(Matchers.anyInt(), Matchers.anyInt());
        return indicator;
    }

    @Test
    public void shouldPrintADotEveryHalfPercentAndFullPercentageEveryTenPercentWithTextualIndicator() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ProgressListener progressListener = ProgressMonitorFactory.textual((OutputStream)stream).singlePart(this.testName.getMethodName(), 1000L);
        for (int i = 0; i < 1000; ++i) {
            progressListener.add(1L);
        }
        Assert.assertEquals((Object)(this.testName.getMethodName() + LINE_SEPARATOR + EXPECTED_TEXTUAL_OUTPUT), (Object)stream.toString(Charset.defaultCharset().name()));
    }

    @Test
    public void shouldPrintADotEveryHalfPercentAndFullPercentageEveryTenPercentEvenWhenStepResolutionIsLower() throws Exception {
        StringWriter writer = new StringWriter();
        ProgressListener progressListener = ProgressMonitorFactory.textual((Writer)writer).singlePart(this.testName.getMethodName(), 50L);
        for (int i = 0; i < 50; ++i) {
            progressListener.add(1L);
        }
        Assert.assertEquals((Object)(this.testName.getMethodName() + LINE_SEPARATOR + EXPECTED_TEXTUAL_OUTPUT), (Object)writer.toString());
    }

    @Test
    public void shouldPassThroughAllInvocationsOnDecorator() throws Exception {
        Indicator decorated = (Indicator)Mockito.mock(Indicator.class);
        Indicator.Decorator decorator = new Indicator.Decorator(decorated){};
        decorator.startProcess(4L);
        ((Indicator)Mockito.verify((Object)decorated)).startProcess(4L);
        decorator.startPart("part1", 2L);
        ((Indicator)Mockito.verify((Object)decorated)).startPart("part1", 2L);
        decorator.progress(0, 1);
        ((Indicator)Mockito.verify((Object)decorated)).progress(0, 1);
        decorator.startPart("part2", 2L);
        ((Indicator)Mockito.verify((Object)decorated)).startPart("part2", 2L);
        decorator.progress(1, 2);
        ((Indicator)Mockito.verify((Object)decorated)).progress(1, 2);
        decorator.completePart("part1");
        ((Indicator)Mockito.verify((Object)decorated)).completePart("part1");
        decorator.progress(2, 3);
        ((Indicator)Mockito.verify((Object)decorated)).progress(2, 3);
        decorator.completePart("part2");
        ((Indicator)Mockito.verify((Object)decorated)).completePart("part2");
        decorator.progress(3, 4);
        ((Indicator)Mockito.verify((Object)decorated)).progress(3, 4);
        decorator.completeProcess();
        ((Indicator)Mockito.verify((Object)decorated)).completeProcess();
    }

    @Test
    public void shouldBeAbleToAwaitCompletionOfMultiPartProgress() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = ProgressMonitorFactory.NONE.multipleParts(this.testName.getMethodName());
        ProgressListener part1 = builder.progressForPart("part1", 1L);
        ProgressListener part2 = builder.progressForPart("part2", 1L);
        final Completion completion = builder.build();
        final CountDownLatch begin = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                begin.countDown();
                try {
                    completion.await(1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    return;
                }
                end.countDown();
            }
        }.start();
        Runnable callback = (Runnable)Mockito.mock(Runnable.class);
        completion.notify(callback);
        Assert.assertTrue((boolean)begin.await(1L, TimeUnit.SECONDS));
        Mockito.verifyZeroInteractions((Object[])new Object[]{callback});
        try {
            completion.await(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (TimeoutException expected) {
            Assert.assertEquals((Object)"Process did not complete within 1 MILLISECONDS.", (Object)expected.getMessage());
        }
        part1.done();
        Mockito.verifyZeroInteractions((Object[])new Object[]{callback});
        part2.done();
        ((Runnable)Mockito.verify((Object)callback)).run();
        completion.await(0L, TimeUnit.NANOSECONDS);
        Assert.assertTrue((boolean)end.await(1L, TimeUnit.SECONDS));
        callback = (Runnable)Mockito.mock(Runnable.class);
        completion.notify(callback);
        ((Runnable)Mockito.verify((Object)callback)).run();
    }

    @Test
    public void shouldReturnToCompletionWaiterWhenFirstJobFails() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = ProgressMonitorFactory.NONE.multipleParts(this.testName.getMethodName());
        ProgressListener part1 = builder.progressForPart("part1", 1L);
        ProgressListener part2 = builder.progressForPart("part2", 1L);
        Completion completion = builder.build();
        part1.started();
        part2.started();
        part2.failed((Throwable)new RuntimeException("failure in one of the jobs"));
        try {
            completion.await(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ProcessFailureException expected) {
            Assert.assertEquals((Object)"failure in one of the jobs", (Object)expected.getCause().getMessage());
        }
    }

    @Test
    public void shouldNotAllowNullCompletionCallbacks() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = ProgressMonitorFactory.NONE.multipleParts(this.testName.getMethodName());
        Completion completion = builder.build();
        try {
            completion.notify(null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"callback may not be null", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldInvokeAllCallbacksEvenWhenOneThrowsException() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder builder = ProgressMonitorFactory.NONE.multipleParts(this.testName.getMethodName());
        ProgressListener progressListener = builder.progressForPart("only part", 1L);
        Completion completion = builder.build();
        Runnable callback = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable)new RuntimeException("on purpose")).doNothing().when((Object)callback)).run();
        completion.notify(callback);
        completion.notify(callback);
        progressListener.done();
        ((Runnable)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).run();
    }

    @Test
    public void shouldAllowStartingAPartBeforeCompletionOfMultiPartBuilder() throws Exception {
        Indicator indicator = (Indicator)Mockito.mock(Indicator.class);
        ProgressMonitorFactory.MultiPartBuilder builder = this.factory.mock(indicator, 10).multipleParts(this.testName.getMethodName());
        ProgressListener part1 = builder.progressForPart("part1", 1L);
        ProgressListener part2 = builder.progressForPart("part2", 1L);
        part1.add(1L);
        builder.build();
        part2.add(1L);
        part1.done();
        part2.done();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator)order.verify((Object)indicator)).startPart("part1", 1L);
        ((Indicator)order.verify((Object)indicator)).startProcess(2L);
        ((Indicator)order.verify((Object)indicator)).startPart("part2", 1L);
        ((Indicator)order.verify((Object)indicator)).completePart("part1");
        ((Indicator)order.verify((Object)indicator)).completePart("part2");
        ((Indicator)order.verify((Object)indicator)).completeProcess();
    }

    @Test
    public void shouldAllowOpenEndedProgressListeners() throws Exception {
        Indicator.OpenEnded indicator = (Indicator.OpenEnded)Mockito.mock(Indicator.OpenEnded.class);
        ProgressListener progress = this.factory.mock(indicator).openEnded(this.testName.getMethodName(), 10);
        for (int i = 0; i < 20; ++i) {
            progress.add(5L);
        }
        progress.done();
        ((Indicator.OpenEnded)Mockito.verify((Object)indicator, (VerificationMode)Mockito.atLeast((int)1))).reportResolution();
        InOrder order = Mockito.inOrder((Object[])new Object[]{indicator});
        ((Indicator.OpenEnded)order.verify((Object)indicator)).startProcess(0L);
        for (int i = 0; i < 10; ++i) {
            ((Indicator.OpenEnded)order.verify((Object)indicator)).progress(i, i + 1);
        }
        ((Indicator.OpenEnded)order.verify((Object)indicator)).completeProcess();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indicator});
    }

    @Test
    public void shouldReportOpenEndedProgressInANiceWay() throws Exception {
        StringWriter buffer = new StringWriter();
        ProgressListener progress = ProgressMonitorFactory.textual((Writer)buffer).openEnded(this.testName.getMethodName(), 10);
        for (int i = 0; i < 25; ++i) {
            progress.add(50L);
        }
        progress.done();
        Assert.assertEquals((Object)String.format(this.testName.getMethodName() + "%n" + "....................     200%n" + "....................     400%n" + "....................     600%n" + "....................     800%n" + "....................    1000%n" + "....................    1200%n" + ".....                   done%n", new Object[0]), (Object)buffer.toString());
    }

    static {
        StringWriter expectedTextualOutput = new StringWriter();
        int i = 0;
        while (i < 10) {
            for (int j = 0; j < 20; ++j) {
                expectedTextualOutput.write(46);
            }
            expectedTextualOutput.write(String.format(" %3d%%%n", ++i * 10));
        }
        EXPECTED_TEXTUAL_OUTPUT = expectedTextualOutput.toString();
    }

    private static class SingleIndicator
    implements TestRule {
        private final Map<ProgressMonitorFactory, Boolean> factoryMocks = new HashMap<ProgressMonitorFactory, Boolean>();

        private SingleIndicator() {
        }

        ProgressMonitorFactory mock(Indicator indicatorMock, int indicatorSteps) {
            Mockito.when((Object)indicatorMock.reportResolution()).thenReturn((Object)indicatorSteps);
            ProgressMonitorFactory factory = (ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class);
            Mockito.when((Object)factory.newIndicator((String)Matchers.any(String.class))).thenReturn((Object)indicatorMock);
            this.factoryMocks.put(factory, false);
            return factory;
        }

        ProgressMonitorFactory mock(final Indicator.OpenEnded indicatorMock) {
            ProgressMonitorFactory factory = (ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class);
            Mockito.when((Object)factory.newOpenEndedIndicator((String)Matchers.any(String.class), Matchers.anyInt())).thenAnswer((Answer)new Answer<Indicator>(){

                public Indicator answer(InvocationOnMock invocation) throws Throwable {
                    Mockito.when((Object)indicatorMock.reportResolution()).thenReturn((Object)((Integer)invocation.getArguments()[1]));
                    return indicatorMock;
                }
            });
            this.factoryMocks.put(factory, true);
            return factory;
        }

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    base.evaluate();
                    for (Map.Entry factoryMock : SingleIndicator.this.factoryMocks.entrySet()) {
                        if (((Boolean)factoryMock.getValue()).booleanValue()) {
                            ((ProgressMonitorFactory)Mockito.verify(factoryMock.getKey(), (VerificationMode)Mockito.times((int)1))).newOpenEndedIndicator((String)Matchers.any(String.class), Matchers.anyInt());
                            continue;
                        }
                        ((ProgressMonitorFactory)Mockito.verify(factoryMock.getKey(), (VerificationMode)Mockito.times((int)1))).newIndicator((String)Matchers.any(String.class));
                    }
                }
            };
        }
    }
}

