/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class RecoveryLabelScanWriterProviderTest {
    @Test
    public void shouldOnlyWriteChangesAfterFullBatch() throws Exception {
        LabelScanStore store = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        LabelScanWriter storeWriter = (LabelScanWriter)Mockito.mock(LabelScanWriter.class);
        Mockito.when((Object)store.newWriter()).thenReturn((Object)storeWriter);
        int batchSize = 5;
        ArrayList<NodeLabelUpdate> expectedUpdates = new ArrayList<NodeLabelUpdate>();
        try (RecoveryLabelScanWriterProvider provider = new RecoveryLabelScanWriterProvider(store, batchSize);){
            for (int b = 0; b < 3; ++b) {
                for (int i = 0; i < batchSize - 1; ++i) {
                    this.simulateTransaction((Provider<LabelScanWriter>)provider, b * 100 + batchSize - i, expectedUpdates);
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{storeWriter});
                }
                this.simulateTransaction((Provider<LabelScanWriter>)provider, b * 100 + batchSize * 2, expectedUpdates);
                for (NodeLabelUpdate update : expectedUpdates) {
                    ((LabelScanWriter)Mockito.verify((Object)storeWriter)).write(update);
                }
                ((LabelScanWriter)Mockito.verify((Object)storeWriter)).close();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{storeWriter});
                Mockito.reset((Object[])new LabelScanWriter[]{storeWriter});
                expectedUpdates.clear();
            }
        }
    }

    private void simulateTransaction(Provider<LabelScanWriter> provider, int i, List<NodeLabelUpdate> expectedUpdates) throws Exception {
        try (LabelScanWriter writer = (LabelScanWriter)provider.instance();){
            NodeLabelUpdate update = NodeLabelUpdate.labelChanges((long)i, (long[])this.longs(new long[0]), (long[])this.longs(1L));
            expectedUpdates.add(update);
            writer.write(update);
        }
    }

    private long[] longs(long ... longs) {
        return longs;
    }
}

