/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.test.ThreadingRule;

public class ArrayEncoderTest {
    @Rule
    public final ThreadingRule threads = new ThreadingRule();
    private static final Character[] base64chars = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('+'), Character.valueOf('/')};
    private static final char ARRAY_ENTRY_SEPARATOR = '|';
    private static final char PADDING = '=';

    @Test
    public void encodingShouldContainOnlyBase64EncodingChars() throws Exception {
        String[] array = new String[]{"This string is long enough for BASE64 to emit a line break, making the encoding platform dependant.", "Something else to trigger padding."};
        String encoded = ArrayEncoder.encode((Object)array);
        int separators = 0;
        boolean padding = false;
        for (int i = 0; i < encoded.length(); ++i) {
            char character = encoded.charAt(i);
            if (character == '|') {
                padding = false;
                ++separators;
                continue;
            }
            if (padding) {
                Assert.assertEquals((long)61L, (long)character);
                continue;
            }
            if (character == '=') {
                padding = true;
                continue;
            }
            Assert.assertTrue((String)("Char " + character + " at position " + i + " is not a valid Base64 encoded char"), (boolean)ArrayUtil.contains((Object[])base64chars, (Object)Character.valueOf(character)));
        }
        Assert.assertEquals((long)array.length, (long)separators);
    }

    @Test
    public void shouldEncodeArrays() throws Exception {
        Assert.assertEquals((Object)"D1.0|2.0|3.0|", (Object)ArrayEncoder.encode((Object)new int[]{1, 2, 3}));
        Assert.assertEquals((Object)"Ztrue|false|", (Object)ArrayEncoder.encode((Object)new boolean[]{true, false}));
        Assert.assertEquals((Object)"LYWxp|YXJl|eW91|b2s=|", (Object)ArrayEncoder.encode((Object)new String[]{"ali", "are", "you", "ok"}));
    }

    @Test
    public void shouldEncodeProperlyWithMultipleThreadsRacing() throws Exception {
        String[] INPUT = new String[]{"These strings need to be longer than 57 bytes, because that is the line wrapping length of BASE64.", "This next line is also long. The number of strings in this array is the number of threads to use.", "Each thread will get a different string as input to encode, and ensure the result is always the same.", "Should the result of an encoding differ even once, the thread will yield a negative overall result.", "If any of the threads yields a negative result, the test will fail, since that should not happen.", "All threads are allowed to run together for a predetermined amount of time, to try to get contention.", "This predetermined time is the minimum runtime of the test, since the timer starts after all threads.", "The idea to use the input data as documentation for the test was just a cute thing I came up with.", "Since my imagination for coming up with test data is usually poor, I figured I'd do something useful.", "Hopefully this isn't just nonsensical drivel, and maybe, just maybe someone might actually read it."};
        long executionTime = TimeUnit.SECONDS.toMillis(5L);
        final AtomicBoolean running = new AtomicBoolean(true);
        Function<String, Boolean> function = new Function<String, Boolean>(){

            public Boolean apply(String input) {
                String first = ArrayEncoder.encode((Object)new String[]{input});
                do {
                    if (first.equals(ArrayEncoder.encode((Object)new String[]{input}))) continue;
                    return false;
                } while (running.get());
                return true;
            }
        };
        ArrayList futures = new ArrayList();
        for (String input : INPUT) {
            futures.add(this.threads.execute(function, input));
        }
        Thread.sleep(executionTime);
        running.set(false);
        for (Future future : futures) {
            Assert.assertTrue((String)"Each attempt at encoding should yield the same result.", (boolean)((Boolean)future.get()));
        }
    }
}

