/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.transaction.command.Command;

public class CountsStoreApplierTest {
    private final CountsAccessor.Updater updater = (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class);

    @Test
    public void shouldNotifyCacheAccessOnHowManyUpdatesOnCountsWeHadSoFar() throws IOException {
        CountsStoreApplier applier = new CountsStoreApplier(this.updater);
        applier.visitNodeCountsCommand(this.addNodeCommand());
        applier.apply();
        ((CountsAccessor.Updater)Mockito.verify((Object)this.updater, (VerificationMode)Mockito.times((int)1))).incrementNodeCount(-1, 1L);
    }

    private Command.NodeCountsCommand addNodeCommand() {
        Command.NodeCountsCommand command = new Command.NodeCountsCommand();
        command.init(-1, 1L);
        return command;
    }
}

