/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.ImpermanentDatabaseRule;

public class KernelSchemaStateFlushingTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseAPI db;
    private KernelAPI kernel;

    @Test
    public void shouldKeepSchemaStateIfSchemaIsNotModified() throws TransactionFailureException {
        String before = this.commitToSchemaState("test", "before");
        Assert.assertEquals((Object)"before", (Object)before);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"before", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateIndex() throws Exception {
        this.commitToSchemaState("test", "before");
        IndexDescriptor descriptor = this.createIndex();
        this.awaitIndexOnline(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropIndex() throws Exception {
        IndexDescriptor descriptor = this.createIndex();
        this.awaitIndexOnline(descriptor);
        this.commitToSchemaState("test", "before");
        this.dropIndex(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateConstraint() throws Exception {
        this.commitToSchemaState("test", "before");
        this.createConstraint();
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropConstraint() throws Exception {
        UniquenessConstraint descriptor = this.createConstraint();
        this.commitToSchemaState("test", "before");
        this.dropConstraint(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    /*
     * Exception decompiling
     */
    private UniquenessConstraint createConstraint() throws KernelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void dropConstraint(UniquenessConstraint descriptor) throws KernelException {
        try (KernelTransaction transaction = this.kernel.newTransaction();
             Statement statement = transaction.acquireStatement();){
            statement.schemaWriteOperations().constraintDrop(descriptor);
            transaction.success();
        }
    }

    /*
     * Exception decompiling
     */
    private IndexDescriptor createIndex() throws KernelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void dropIndex(IndexDescriptor descriptor) throws KernelException {
        try (KernelTransaction transaction = this.kernel.newTransaction();
             Statement statement = transaction.acquireStatement();){
            statement.schemaWriteOperations().indexDrop(descriptor);
            transaction.success();
        }
    }

    private void awaitIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, TransactionFailureException {
        try (KernelTransaction transaction = this.kernel.newTransaction();
             Statement statement = transaction.acquireStatement();){
            SchemaIndexTestHelper.awaitIndexOnline(statement.readOperations(), descriptor);
            transaction.success();
        }
    }

    private String commitToSchemaState(String key, String value) throws TransactionFailureException {
        try (KernelTransaction transaction = this.kernel.newTransaction();){
            String result = this.getOrCreateFromState(transaction, key, value);
            transaction.success();
            String string = result;
            return string;
        }
    }

    private String getOrCreateFromState(KernelTransaction tx, String key, final String value) {
        try (Statement statement = tx.acquireStatement();){
            String string = (String)statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, String>(){

                public String apply(String from) {
                    return value;
                }
            });
            return string;
        }
    }

    @Before
    public void setup() {
        this.db = this.dbRule.getGraphDatabaseAPI();
        this.kernel = (KernelAPI)this.db.getDependencyResolver().resolveDependency(KernelAPI.class);
    }

    @After
    public void after() {
        this.db.shutdown();
    }
}

