/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.AggregatedReservation;

public class AggregatedReservationTest {
    @Test
    public void shouldThrowWhenTooManyAggregatesAdded() {
        int size = 5;
        AggregatedReservation aggregatedReservation = new AggregatedReservation(size);
        for (int i = 0; i < size; ++i) {
            aggregatedReservation.add((Reservation)Mockito.mock(Reservation.class));
        }
        try {
            aggregatedReservation.add((Reservation)Mockito.mock(Reservation.class));
            Assert.fail((String)("Should have thrown " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Too many aggregates"));
        }
    }

    @Test
    public void releaseShouldBeNullSafe() {
        AggregatedReservation aggregatedReservation = new AggregatedReservation(10);
        Reservation aggregate1 = (Reservation)Mockito.mock(Reservation.class);
        Reservation aggregate3 = (Reservation)Mockito.mock(Reservation.class);
        aggregatedReservation.add(aggregate1);
        aggregatedReservation.add(null);
        aggregatedReservation.add(aggregate3);
        aggregatedReservation.release();
        ((Reservation)Mockito.verify((Object)aggregate1)).release();
        ((Reservation)Mockito.verify((Object)aggregate3)).release();
    }

    @Test
    public void shouldReleaseAllAggregatedReservations() {
        AggregatedReservation aggregatedReservation = new AggregatedReservation(3);
        Reservation aggregate1 = (Reservation)Mockito.mock(Reservation.class);
        Reservation aggregate2 = (Reservation)Mockito.mock(Reservation.class);
        Reservation aggregate3 = (Reservation)Mockito.mock(Reservation.class);
        aggregatedReservation.add(aggregate1);
        aggregatedReservation.add(aggregate2);
        aggregatedReservation.add(aggregate3);
        aggregatedReservation.release();
        ((Reservation)Mockito.verify((Object)aggregate1)).release();
        ((Reservation)Mockito.verify((Object)aggregate2)).release();
        ((Reservation)Mockito.verify((Object)aggregate3)).release();
    }

    @Test
    public void shouldReleaseAllAggregatedReservationsEvenIfOneOfThemThrows() {
        AggregatedReservation aggregatedReservation = new AggregatedReservation(3);
        Reservation aggregate1 = (Reservation)Mockito.mock(Reservation.class);
        Reservation aggregate2 = (Reservation)Mockito.mock(Reservation.class);
        IllegalStateException exception = new IllegalStateException();
        ((Reservation)Mockito.doThrow((Throwable)exception).when((Object)aggregate2)).release();
        Reservation aggregate3 = (Reservation)Mockito.mock(Reservation.class);
        aggregatedReservation.add(aggregate1);
        aggregatedReservation.add(aggregate2);
        aggregatedReservation.add(aggregate3);
        try {
            aggregatedReservation.release();
            Assert.fail((String)("Should have thrown " + IllegalStateException.class.getSimpleName()));
        }
        catch (IllegalStateException e) {
            Assert.assertSame((Object)exception, (Object)e);
        }
        ((Reservation)Mockito.verify((Object)aggregate1)).release();
        ((Reservation)Mockito.verify((Object)aggregate2)).release();
        ((Reservation)Mockito.verify((Object)aggregate3)).release();
    }

    @Test
    public void shouldThrowLaunderedException() {
        AggregatedReservation aggregatedReservation = new AggregatedReservation(1);
        Reservation reservation = (Reservation)Mockito.mock(Reservation.class);
        RuntimeException exception = new RuntimeException("Error");
        ((Reservation)Mockito.doThrow((Throwable)exception).when((Object)reservation)).release();
        aggregatedReservation.add(reservation);
        try {
            aggregatedReservation.release();
            Assert.fail((String)("Should have thrown " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)exception);
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void shouldNotAllowRecursiveAggregations() {
        AggregatedReservation aggregatedReservation = new AggregatedReservation(1);
        try {
            aggregatedReservation.add((Reservation)aggregatedReservation);
            Assert.fail((String)("Should have thrown " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Recursive"));
        }
    }
}

