/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;

public class RelationshipChangesForNodeTest {
    public static final PrimitiveLongIterator EMPTY = new PrimitiveLongIterator(){

        public boolean hasNext() {
            return false;
        }

        public long next() {
            return -1L;
        }
    };
    public static final int REL_0 = 0;
    public static final int REL_1 = 1;
    public static final int TYPE_SELF = 0;
    public static final int TYPE_DIR = 1;

    @Test
    public void testOutgoingRelsWithTypeAndLoop() throws Exception {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.OUTGOING);
        PrimitiveLongIterator iterator = changes.augmentRelationships(Direction.OUTGOING, new int[]{1}, EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testIncomingRelsWithTypeAndLoop() throws Exception {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.INCOMING);
        PrimitiveLongIterator iterator = changes.augmentRelationships(Direction.INCOMING, new int[]{1}, EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }
}

