/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.api.store.DiskLayerTest;

public class DiskLayerNodeAndRelTest
extends DiskLayerTest {
    @Test
    public void shouldTellIfNodeExists() throws Exception {
        long created = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long createdAndRemoved = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long neverExisted = createdAndRemoved + 99L;
        try (Transaction tx = this.db.beginTx();){
            this.db.getNodeById(createdAndRemoved).delete();
            tx.success();
        }
        TestCase.assertTrue((boolean)this.disk.nodeExists(created));
        Assert.assertFalse((boolean)this.disk.nodeExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.disk.nodeExists(neverExisted));
    }

    @Test
    public void shouldTellIfRelExists() throws Exception {
        long createdAndRemoved;
        long created;
        long node = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        try (Transaction tx = this.db.beginTx();){
            created = this.db.createNode().createRelationshipTo(this.db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"Banana")).getId();
            createdAndRemoved = this.db.createNode().createRelationshipTo(this.db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"Banana")).getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var10_3 = null;
        try {
            this.db.getRelationshipById(createdAndRemoved).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var10_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var10_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long neverExisted = created + 99L;
        TestCase.assertTrue((boolean)this.disk.relationshipExists(node));
        Assert.assertFalse((boolean)this.disk.relationshipExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.disk.relationshipExists(neverExisted));
    }
}

