/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.index.DummyIndexImplementation;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DummyIndexExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String IDENTIFIER = "test-dummy-neo-index";
    public static final String KEY_FAIL_ON_MUTATE = "fail_on_mutate";
    private InternalAbstractGraphDatabase db;

    public DummyIndexExtensionFactory() {
        super(IDENTIFIER);
    }

    public Lifecycle newKernelExtension(Dependencies dependencies) throws Throwable {
        this.db = dependencies.getDatabase();
        IndexProviders indexProviders = dependencies.getIndexProviders();
        return new Extension(indexProviders);
    }

    private static class Extension
    extends LifecycleAdapter {
        private final IndexProviders indexProviders;

        public Extension(IndexProviders indexProviders) {
            this.indexProviders = indexProviders;
        }

        public void init() throws Throwable {
            this.indexProviders.registerIndexProvider(DummyIndexExtensionFactory.IDENTIFIER, (IndexImplementation)new DummyIndexImplementation());
        }

        public void shutdown() throws Throwable {
            this.indexProviders.unregisterIndexProvider(DummyIndexExtensionFactory.IDENTIFIER);
        }
    }

    public static interface Dependencies {
        public InternalAbstractGraphDatabase getDatabase();

        public IndexProviders getIndexProviders();
    }
}

