/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.io.File;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.test.TargetDirectory;

public class LockWorkFailureDump {
    private final Class<?> testClass;

    public LockWorkFailureDump(Class<?> testClass) {
        this.testClass = testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpState(Locks lm, LockWorker ... workers) {
        LifeSupport life = new LifeSupport();
        File file = TargetDirectory.forTest(this.testClass).file("failure-dump-" + System.currentTimeMillis());
        Logging logging = (Logging)life.add((Object)new SingleLoggingService(StringLogger.logger((File)file)));
        life.start();
        try {
            lm.accept((Locks.Visitor)new DumpLocksVisitor(logging.getMessagesLog(LockWorkFailureDump.class)));
            for (LockWorker worker : workers) {
                logging.getMessagesLog(this.getClass()).logLongMessage("Worker " + worker, (Visitor)worker);
            }
            File file2 = file;
            return file2;
        }
        finally {
            life.shutdown();
        }
    }
}

