/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PropertyRecordTest {
    @Test
    public void addingDuplicatePropertyBlockShouldOverwriteExisting() {
        PropertyRecord record = new PropertyRecord(1L);
        PropertyBlock blockA = new PropertyBlock();
        blockA.setValueBlocks(new long[1]);
        blockA.setKeyIndexId(2);
        PropertyBlock blockB = new PropertyBlock();
        blockB.setValueBlocks(new long[1]);
        blockB.setKeyIndexId(2);
        record.setPropertyBlock(blockA);
        record.setPropertyBlock(blockB);
        List propertyBlocks = IteratorUtil.asList((Iterable)record);
        Assert.assertThat((Object)propertyBlocks, (Matcher)Matchers.hasItem((Object)blockB));
        Assert.assertThat((Object)propertyBlocks, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldIterateOverBlocks() throws Exception {
        PropertyRecord record = new PropertyRecord(0L);
        PropertyBlock[] blocks = new PropertyBlock[3];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = new PropertyBlock();
            record.addPropertyBlock(blocks[i]);
        }
        Iterator iterator = record.iterator();
        for (int i = 0; i < blocks.length; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)blocks[i], iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldBeAbleToRemoveBlocksDuringIteration() throws Exception {
        PropertyRecord record = new PropertyRecord(0L);
        HashSet<PropertyBlock> blocks = new HashSet<PropertyBlock>();
        for (int i = 0; i < 4; ++i) {
            PropertyBlock block = new PropertyBlock();
            record.addPropertyBlock(block);
            blocks.add(block);
        }
        Iterator iterator = record.iterator();
        this.assertIteratorRemoveThrowsIllegalState(iterator);
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            PropertyBlock block = (PropertyBlock)iterator.next();
            if (i % 2 != 1) continue;
            iterator.remove();
            this.assertIteratorRemoveThrowsIllegalState(iterator);
            blocks.remove(block);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals(blocks, (Object)IteratorUtil.asSet((Iterable)record));
    }

    private void assertIteratorRemoveThrowsIllegalState(Iterator<PropertyBlock> iterator) {
        try {
            iterator.remove();
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

