/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class TestArrayStore {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    private File dir;
    private DynamicArrayStore arrayStore;

    @Before
    public void before() throws Exception {
        this.dir = TargetDirectory.forTest(this.getClass()).cleanDirectory("db");
        Map configParams = MapUtil.stringMap((String[])new String[0]);
        Config config = new Config(configParams);
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        Monitors monitors = new Monitors();
        PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        StoreFactory factory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, monitors);
        File fileName = new File(this.dir, "arraystore");
        factory.createDynamicArrayStore(fileName, 120);
        this.arrayStore = new DynamicArrayStore(fileName, config, IdType.ARRAY_BLOCK, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, monitors);
    }

    @After
    public void after() throws Exception {
        if (this.arrayStore != null) {
            this.arrayStore.close();
        }
    }

    @Test
    public void intArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7}, PropertyType.INT, 3, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7, 8}, PropertyType.INT, 4, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1000, 10000, 13000}, PropertyType.INT, 14, 2);
    }

    @Test
    public void longArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, PropertyType.LONG, 3, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}, PropertyType.LONG, 4, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1000L, 10000L, 13000L, 15000000000L}, PropertyType.LONG, 34, 2);
    }

    @Test
    public void byteArrayPropertiesShouldNotBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new byte[]{1, 2, 3, 4, 5}, PropertyType.BYTE, 8, 1);
    }

    @Test
    public void stringArrayGetsStoredAsUtf8() throws Exception {
        String[] array = new String[]{"first", "second"};
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.arrayStore.allocateRecords(records, (Object)array, (Iterator)IteratorUtil.emptyIterator());
        Pair<byte[], byte[]> loaded = this.loadArray(records);
        this.assertStringHeader((byte[])loaded.first(), array.length);
        ByteBuffer buffer = ByteBuffer.wrap((byte[])loaded.other());
        for (String item : array) {
            byte[] expectedData = UTF8.encode((String)item);
            Assert.assertEquals((long)expectedData.length, (long)buffer.getInt());
            byte[] loadedItem = new byte[expectedData.length];
            buffer.get(loadedItem);
            Assert.assertTrue((boolean)Arrays.equals(expectedData, loadedItem));
        }
    }

    private void assertStringHeader(byte[] header, int itemCount) {
        Assert.assertEquals((long)PropertyType.STRING.byteValue(), (long)header[0]);
        Assert.assertEquals((long)itemCount, (long)ByteBuffer.wrap(header, 1, 4).getInt());
    }

    private void assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(Object array, PropertyType type, int expectedBitsUsedPerItem, int expectedRecordCount) {
        Collection<DynamicRecord> records = this.storeArray(array);
        Pair<byte[], byte[]> asBytes = this.loadArray(records);
        this.assertArrayHeader((byte[])asBytes.first(), type, expectedBitsUsedPerItem);
        Bits bits = Bits.bitsFromBytes((byte[])((byte[])asBytes.other()));
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((long)((Number)Array.get(array, i)).longValue(), (long)bits.getLong(expectedBitsUsedPerItem));
        }
    }

    private void assertArrayHeader(byte[] header, PropertyType type, int bitsPerItem) {
        Assert.assertEquals((long)type.byteValue(), (long)header[0]);
        Assert.assertEquals((long)bitsPerItem, (long)header[2]);
    }

    private Collection<DynamicRecord> storeArray(Object array) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.arrayStore.allocateRecords(records, array, (Iterator)IteratorUtil.emptyIterator());
        for (DynamicRecord record : records) {
            this.arrayStore.updateRecord(record);
        }
        return records;
    }

    private Pair<byte[], byte[]> loadArray(Collection<DynamicRecord> records) {
        return this.arrayStore.readFullByteArray(records, PropertyType.ARRAY);
    }
}

