/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.format.v2_2.RecordFormatTest;
import org.neo4j.kernel.impl.store.format.v2_2.RelationshipStoreFormat_v2_2;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipFormatTest
extends RecordFormatTest<RelationshipStoreFormat_v2_2, RelationshipRecord, RelationshipStoreFormat_v2_2.RelationshipRecordCursor> {
    public RelationshipFormatTest() {
        super(new RelationshipStoreFormat_v2_2());
    }

    @Test
    public void testDirectRecordSerialization() throws Exception {
        this.assertSerializes(new RelationshipRecord(12L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, false));
        this.assertSerializes(new RelationshipRecord(12L, true, IdType.NODE.getMaxValue(), IdType.NODE.getMaxValue(), (int)IdType.RELATIONSHIP_TYPE_TOKEN.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), false, false));
        this.assertSerializes(new RelationshipRecord(12L, true, IdType.NODE.getMaxValue(), IdType.NODE.getMaxValue(), (int)IdType.RELATIONSHIP_TYPE_TOKEN.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), 0L, IdType.RELATIONSHIP.getMaxValue(), IdType.RELATIONSHIP.getMaxValue(), false, true));
    }

    @Test
    public void testCursorFieldReading() throws Exception {
        String reuseToString;
        boolean inUse;
        long recordId;
        RelationshipStoreFormat_v2_2.RelationshipRecordCursor cursor = ((RelationshipStoreFormat_v2_2)this.format).createCursor(this.pagedFile, this.storeToolkit, 0);
        RelationshipRecord record = new RelationshipRecord(12L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, false);
        this.writeToPagedFile(record);
        cursor.position(12L);
        do {
            recordId = cursor.recordId();
            inUse = cursor.inUse();
            reuseToString = ((RelationshipRecord)cursor.reusedRecord()).toString();
        } while (cursor.shouldRetry());
        MatcherAssert.assertThat((Object)recordId, (Matcher)CoreMatchers.equalTo((Object)12L));
        MatcherAssert.assertThat((Object)inUse, (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)reuseToString, (Matcher)CoreMatchers.equalTo((Object)record.toString()));
    }
}

