/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.test.EphemeralFileSystemRule;

public class NeoStoreUtilTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldNotReadTrailerAsRecordData() throws Exception {
        long[] values = new long[]{1L, 2L, 3L, 4L, 5L};
        NeoStoreUtil access = new NeoStoreUtil(this.neoStoreFile((FileSystemAbstraction)this.fs.get(), true, values), (FileSystemAbstraction)this.fs.get());
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)values[i], (long)access.getValue(NeoStore.Position.values()[i]));
        }
        try {
            access.getValue(NeoStore.Position.values()[values.length]);
            Assert.fail((String)"Shouldn't have read more records");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReadAllRecordsEvenOnStoreWithoutTrailer() throws Exception {
        long[] values = new long[]{1L, 2L, 3L, 4L, 5L};
        NeoStoreUtil access = new NeoStoreUtil(this.neoStoreFile((FileSystemAbstraction)this.fs.get(), false, values), (FileSystemAbstraction)this.fs.get());
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)values[i], (long)access.getValue(NeoStore.Position.values()[i]));
        }
        try {
            access.getValue(NeoStore.Position.values()[values.length]);
            Assert.fail((String)"Shouldn't have read more records");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private File neoStoreFile(FileSystemAbstraction fs, boolean addVersionTrailer, long ... recordValues) throws IOException {
        File dir = new File("dir");
        fs.mkdirs(dir);
        try (StoreChannel channel = fs.create(new File(dir, "neostore"));){
            ByteBuffer buffer = ByteBuffer.allocate(9);
            for (long recordValue : recordValues) {
                buffer.clear();
                buffer.put(Record.IN_USE.byteValue());
                buffer.putLong(recordValue);
                buffer.flip();
                channel.write(buffer);
            }
            if (addVersionTrailer) {
                channel.write(ByteBuffer.wrap(UTF8.encode((String)NeoStore.buildTypeDescriptorAndVersion((String)"NeoStore"))));
            }
        }
        return dir;
    }
}

