/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.junit.Assert;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.Legacy21Store;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.test.Unzip;

public class MigrationTestUtils {
    private static final Predicate<StoreFile> ALL_EXCEPT_COUNTS_STORE = new Predicate<StoreFile>(){

        public boolean accept(StoreFile item) {
            return item != StoreFile.COUNTS_STORE_LEFT && item != StoreFile.COUNTS_STORE_RIGHT;
        }
    };

    public static Config defaultConfig() {
        return MigrationTestUtils.defaultConfig(MapUtil.stringMap((String[])new String[0]));
    }

    public static Config defaultConfig(Map<String, String> inputParams) {
        return new Config(inputParams, new Class[]{GraphDatabaseSettings.class});
    }

    public static int[] makeLongArray() {
        int[] longArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            longArray[i] = i;
        }
        return longArray;
    }

    public static String makeLongString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("characters");
        }
        return builder.toString();
    }

    public static void changeVersionNumber(FileSystemAbstraction fileSystem, File storeFile, String versionString) throws IOException {
        byte[] versionBytes = UTF8.encode((String)versionString);
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.position(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
        fileChannel.write(ByteBuffer.wrap(versionBytes));
        fileChannel.close();
    }

    public static void truncateFile(FileSystemAbstraction fileSystem, File storeFile, String suffixToDetermineTruncationLength) throws IOException {
        byte[] versionBytes = UTF8.encode((String)suffixToDetermineTruncationLength);
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.truncate(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
        fileChannel.close();
    }

    public static void truncateAllFiles(FileSystemAbstraction fileSystem, File workingDirectory, String version) throws IOException {
        for (StoreFile storeFile : StoreFile.legacyStoreFilesForVersion((String)version)) {
            File file = new File(workingDirectory, storeFile.storeFileName());
            MigrationTestUtils.truncateFile(fileSystem, file, storeFile.forVersion(version));
        }
    }

    public static void truncateToFixedLength(FileSystemAbstraction fileSystem, File storeFile, int newLength) throws IOException {
        StoreChannel fileChannel = fileSystem.open(storeFile, "rw");
        fileChannel.truncate((long)newLength);
        fileChannel.close();
    }

    public static void prepareSampleLegacyDatabase(String version, EphemeralFileSystemAbstraction workingFs, File workingDirectory) throws IOException {
        File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version);
        workingFs.copyRecursivelyFromOtherFs(resourceDirectory, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), workingDirectory);
    }

    public static void prepareSampleLegacyDatabase(String version, FileSystemAbstraction workingFs, File workingDirectory) throws IOException {
        File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version);
        workingFs.deleteRecursively(workingDirectory);
        workingFs.mkdirs(workingDirectory);
        workingFs.copyRecursively(resourceDirectory, workingDirectory);
    }

    public static File findFormatStoreDirectoryForVersion(String version) throws IOException {
        switch (version) {
            case "v0.A.3": {
                return MigrationTestUtils.find21FormatStoreDirectory();
            }
            case "v0.A.1": {
                return MigrationTestUtils.find20FormatStoreDirectory();
            }
            case "v0.A.0": {
                return MigrationTestUtils.find19FormatStoreDirectory();
            }
        }
        throw new IllegalArgumentException("Unknown version");
    }

    public static File find21FormatStoreDirectory() throws IOException {
        return Unzip.unzip(Legacy21Store.class, "upgradeTest21Db.zip");
    }

    public static File find21FormatStoreDirectoryWithDuplicateProperties(File directory) throws IOException {
        return Unzip.unzip(Legacy21Store.class, "with-duplicate-properties.zip", directory);
    }

    public static File find20FormatStoreDirectory() throws IOException {
        return Unzip.unzip(Legacy20Store.class, "exampledb.zip");
    }

    public static File find20FormatStoreDirectory(File unzipTarget) throws IOException {
        return Unzip.unzip(Legacy20Store.class, "exampledb.zip", unzipTarget);
    }

    public static File find19FormatStoreDirectory() throws IOException {
        return Unzip.unzip(Legacy19Store.class, "propkeydupdb.zip");
    }

    public static File find19FormatStoreDirectory(File unzipTarget) throws IOException {
        return Unzip.unzip(Legacy19Store.class, "propkeydupdb.zip", unzipTarget);
    }

    public static File find19FormatHugeStoreDirectory() throws IOException {
        return Unzip.unzip(Legacy19Store.class, "upgradeTest19Db.zip");
    }

    public static File find19FormatHugeStoreDirectory(File unzipTarget) throws IOException {
        return Unzip.unzip(Legacy19Store.class, "upgradeTest19Db.zip", unzipTarget);
    }

    public static boolean allStoreFilesHaveVersion(FileSystemAbstraction fileSystem, File workingDirectory, String version) throws IOException {
        Iterable storeFilesWithGivenVersions = Iterables.filter(ALL_EXCEPT_COUNTS_STORE, (Iterable)StoreFile.legacyStoreFilesForVersion((String)version));
        boolean success = true;
        for (StoreFile storeFile : storeFilesWithGivenVersions) {
            StoreChannel channel = fileSystem.open(new File(workingDirectory, storeFile.storeFileName()), "r");
            int length = UTF8.encode((String)version).length;
            byte[] bytes = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(channel.size() - (long)length);
            channel.read(buffer);
            channel.close();
            String foundVersion = UTF8.decode((byte[])bytes);
            if (version.equals(foundVersion)) continue;
            success = false;
        }
        return success;
    }

    public static boolean containsAnyStoreFiles(FileSystemAbstraction fileSystem, File directory) {
        for (StoreFile file : StoreFile.values()) {
            if (!fileSystem.fileExists(new File(directory, file.storeFileName()))) continue;
            return true;
        }
        return false;
    }

    public static void verifyFilesHaveSameContent(FileSystemAbstraction fileSystem, File original, File other) throws IOException {
        File[] files;
        int bufferBatchSize = 32768;
        block18: for (File originalFile : files = fileSystem.listFiles(original)) {
            File otherFile = new File(other, originalFile.getName());
            if (fileSystem.isDirectory(originalFile)) continue;
            try (StoreChannel originalChannel = fileSystem.open(originalFile, "r");
                 StoreChannel otherChannel = fileSystem.open(otherFile, "r");){
                ByteBuffer buffer = ByteBuffer.allocate(32768);
                while (true) {
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)originalChannel, (ByteBuffer)buffer, (int)32768)) {
                        continue block18;
                    }
                    byte[] originalBytes = new byte[buffer.limit()];
                    buffer.get(originalBytes);
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)otherChannel, (ByteBuffer)buffer, (int)32768)) {
                        Assert.fail((String)"Files have different sizes");
                    }
                    byte[] otherBytes = new byte[buffer.limit()];
                    buffer.get(otherBytes);
                    Assert.assertArrayEquals((String)("Different content in " + originalFile), (byte[])originalBytes, (byte[])otherBytes);
                }
            }
        }
    }

    public static File isolatedMigrationDirectoryOf(File dbDirectory) {
        return new File(dbDirectory, "upgrade");
    }
}

