/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookupTest;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DuplicatePropertyRemoverTest {
    @ClassRule
    public static TargetDirectory.TestDirectory storePath = TargetDirectory.testDirForTest(IndexLookupTest.class);
    private static int PROPERTY_COUNT = 1000;
    private static GraphDatabaseAPI api;
    private static Node node;
    private static long nodeId;
    private static NodeStore nodeStore;
    private static List<String> propertyNames;
    private static Map<String, Integer> indexedPropertyKeys;
    private static PropertyStore propertyStore;
    private static DuplicatePropertyRemover remover;

    @BeforeClass
    public static void setUp() {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        GraphDatabaseService db = factory.newEmbeddedDatabase(storePath.absolutePath());
        api = (GraphDatabaseAPI)db;
        Label nodeLabel = DynamicLabel.label((String)"Label");
        propertyNames = new ArrayList<String>();
        try (Transaction transaction = db.beginTx();){
            node = db.createNode(new Label[]{nodeLabel});
            nodeId = node.getId();
            for (int i = 0; i < PROPERTY_COUNT; ++i) {
                String propKey = "key" + i;
                propertyNames.add(propKey);
                String propValue = "value" + i;
                boolean isBigProp = ThreadLocalRandom.current().nextBoolean();
                if (isBigProp) {
                    propValue = propValue + propValue;
                    propValue = propValue + propValue;
                    propValue = propValue + propValue;
                    propValue = propValue + propValue;
                    propValue = propValue + propValue;
                }
                node.setProperty(propKey, (Object)propValue);
            }
            transaction.success();
        }
        Collections.shuffle(propertyNames);
        DependencyResolver resolver = api.getDependencyResolver();
        NeoStoreProvider neoStoreProvider = (NeoStoreProvider)resolver.resolveDependency(NeoStoreProvider.class);
        NeoStore neoStore = (NeoStore)neoStoreProvider.evaluate();
        nodeStore = neoStore.getNodeStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStore.getPropertyKeyTokenStore();
        indexedPropertyKeys = PropertyDeduplicatorTestUtil.indexPropertyKeys(propertyKeyTokenStore);
        propertyStore = neoStore.getPropertyStore();
        remover = new DuplicatePropertyRemover(nodeStore, propertyStore);
    }

    @AfterClass
    public static void tearDown() {
        api.shutdown();
    }

    @Test
    public void shouldRemovePropertyFromLinkedChain() throws Exception {
        int prevProBlockCount = propertyNames.size();
        for (String propertyName : propertyNames) {
            int propertyKeyId = indexedPropertyKeys.get(propertyName);
            NodeRecord nodeRecord = nodeStore.getRecord(nodeId);
            this.removeProperty(nodeRecord, propertyKeyId);
            this.assertPropertyRemoved(nodeRecord, prevProBlockCount, propertyKeyId);
            --prevProBlockCount;
            Assert.assertFalse((boolean)this.hasLoop(nodeRecord.getNextProp()));
        }
    }

    private void assertPropertyRemoved(NodeRecord nodeRecord, int prevProBlockCount, int propertyKeyId) {
        long nextPropId = nodeRecord.getNextProp();
        int propBlockCount = 0;
        while (nextPropId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propertyStore.getRecord(nextPropId);
            PropertyBlock propertyBlock = propRecord.getPropertyBlock(propertyKeyId);
            Assert.assertNull((Object)propertyBlock);
            nextPropId = propRecord.getNextProp();
            propBlockCount += IteratorUtil.count((Iterable)propRecord);
        }
        Assert.assertEquals((long)(prevProBlockCount - 1), (long)propBlockCount);
    }

    private boolean hasLoop(long firstId) {
        PropertyRecord first;
        PropertyRecord fast;
        if (firstId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return false;
        }
        PropertyRecord slow = fast = (first = propertyStore.getRecord(firstId));
        do {
            slow = this.getNextPropertyRecord(slow);
            PropertyRecord nextFast = this.getNextPropertyRecord(fast);
            if (nextFast == null) {
                return false;
            }
            fast = this.getNextPropertyRecord(nextFast);
            if (slow != null && fast != null) continue;
            return false;
        } while (slow.getId() != fast.getId());
        return true;
    }

    private PropertyRecord getNextPropertyRecord(PropertyRecord propRecord) {
        long nextPropId = propRecord.getNextProp();
        propRecord = nextPropId != (long)Record.NO_NEXT_PROPERTY.intValue() ? propertyStore.getRecord(nextPropId) : null;
        return propRecord;
    }

    private void removeProperty(NodeRecord nodeRecord, int propertyKeyId) {
        long nextProp = nodeRecord.getNextProp();
        Assert.assertTrue((nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() ? 1 : 0) != 0);
        boolean found = false;
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() && !found) {
            PropertyRecord propertyRecord = propertyStore.getRecord(nextProp);
            PropertyBlock propertyBlock = propertyRecord.removePropertyBlock(propertyKeyId);
            if (propertyBlock != null) {
                found = true;
                propertyStore.updateRecord(propertyRecord);
                if (!propertyRecord.iterator().hasNext()) {
                    remover.fixUpPropertyLinksAroundUnusedRecord(nodeRecord, propertyRecord);
                }
            }
            nextProp = propertyRecord.getNextProp();
        }
        Assert.assertTrue((boolean)found);
    }
}

