/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.Unzip;
import org.neo4j.tooling.GlobalGraphOperations;

public class ReadMultipleLogEntryVersionsTest {
    @Ignore(value="Run in 2.2.2 to create the database")
    @Test
    public void shouldCreateSomeStuffAndCrashAs222() throws Exception {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            Node node1 = db.createNode(new Label[]{TestLabels.LABEL_ONE});
            Node node2 = db.createNode();
            node2.setProperty("key", (Object)"some very nice value");
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        System.exit(1);
    }

    @Test
    public void shouldRecoveryThatDbAs224() throws Exception {
        File path = Unzip.unzip(this.getClass(), "2.2.2-crashed-db.zip");
        StoreRecoverer recoverer = new StoreRecoverer();
        Assert.assertTrue((boolean)recoverer.recoveryNeededAt(path));
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(path.getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()));
            Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllRelationships()));
            tx.success();
        }
    }
}

