/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class ApplyRecoveredTransactionsTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private NeoStore neoStore;

    @Test
    public void shouldSetCorrectHighIdWhenApplyingExternalTransactions() throws Exception {
        long nodeId = this.neoStore.getNodeStore().nextId();
        long relationshipId = this.neoStore.getRelationshipStore().nextId();
        int type = 1;
        this.applyExternalTransaction(1L, this.nodeCommand(this.node(nodeId), this.inUse(this.created(this.node(nodeId)))), this.relationshipCommand(this.inUse(this.created(this.with(this.relationship(relationshipId), nodeId, nodeId, type)))));
        this.applyExternalTransaction(2L, this.nodeCommand(this.inUse(this.created(this.node(nodeId))), this.node(nodeId)), this.relationshipCommand(this.relationship(relationshipId)));
        Assert.assertEquals((long)(nodeId + 1L), (long)this.neoStore.getNodeStore().getHighId());
        Assert.assertEquals((long)(relationshipId + 1L), (long)this.neoStore.getRelationshipStore().getHighId());
    }

    private RelationshipRecord with(RelationshipRecord relationship, long startNode, long endNode, int type) {
        relationship.setFirstNode(startNode);
        relationship.setSecondNode(endNode);
        relationship.setType(type);
        return relationship;
    }

    private Command relationshipCommand(RelationshipRecord relationship) {
        Command.RelationshipCommand command = new Command.RelationshipCommand();
        command.init(relationship);
        return command;
    }

    private RelationshipRecord relationship(long relationshipId) {
        return new RelationshipRecord(relationshipId);
    }

    private void applyExternalTransaction(long transactionId, Command ... commands) throws IOException {
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(this.neoStore, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), (LockService)Mockito.mock(LockService.class), new LockGroup(), transactionId);
        CommandApplierFacade applierFacade = new CommandApplierFacade(new NeoCommandHandler[]{applier, (NeoCommandHandler)Mockito.mock(NeoCommandHandler.class), (NeoCommandHandler)Mockito.mock(NeoCommandHandler.class), (NeoCommandHandler)Mockito.mock(NeoCommandHandler.class)});
        new PhysicalTransactionRepresentation(Arrays.asList(commands)).accept((Visitor)applierFacade);
    }

    @Before
    public void before() {
        File storeDir = new File("dir");
        Config config = StoreFactory.configForStoreDir((Config)new Config(), (File)storeDir);
        StoreFactory storeFactory = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsr.get()), (FileSystemAbstraction)this.fsr.get(), StringLogger.DEV_NULL, new Monitors());
        this.neoStore = storeFactory.newNeoStore(true);
    }

    @After
    public void after() {
        this.neoStore.close();
    }

    private Command nodeCommand(NodeRecord before, NodeRecord after) {
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(before, after);
        return command;
    }

    private <RECORD extends Abstract64BitRecord> RECORD inUse(RECORD record) {
        record.setInUse(true);
        return record;
    }

    private <RECORD extends Abstract64BitRecord> RECORD created(RECORD record) {
        record.setCreated();
        return record;
    }

    private NodeRecord node(long id) {
        return new NodeRecord(id);
    }

    private long nextNodeId() {
        return this.neoStore.getNodeStore().nextId();
    }
}

