/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.RelationshipLocker;
import org.neo4j.kernel.impl.transaction.state.TrackingRecordAccess;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.unsafe.batchinsert.DirectRecordAccessSet;

public class RelationshipCreatorTest {
    private static final int DENSE_NODE_THRESHOLD = 5;
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.dense_node_threshold, String.valueOf(5));
        }
    };
    private IdGeneratorFactory idGeneratorFactory;

    @Test
    public void shouldOnlyChangeLockedRecordsWhenUpgradingToDenseNode() throws Exception {
        long nodeId = this.createNodeWithRelationships(5);
        NeoStore neoStore = this.flipToNeoStore();
        Tracker tracker = new Tracker(neoStore);
        RelationshipGroupGetter groupGetter = new RelationshipGroupGetter(neoStore.getRelationshipGroupStore());
        RelationshipCreator relationshipCreator = new RelationshipCreator((RelationshipLocker)tracker, groupGetter, 5);
        relationshipCreator.relationshipCreate(this.idGeneratorFactory.get(IdType.RELATIONSHIP).nextId(), 0, nodeId, nodeId, (RecordAccessSet)tracker);
        Assert.assertEquals((long)tracker.relationshipLocksAcquired.size(), (long)tracker.changedRelationships.size());
        Assert.assertFalse((boolean)tracker.relationshipLocksAcquired.isEmpty());
    }

    private NeoStore flipToNeoStore() {
        return (NeoStore)((NeoStoreProvider)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(NeoStoreProvider.class)).evaluate();
    }

    private long createNodeWithRelationships(int count) {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            for (int i = 0; i < count; ++i) {
                node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    @Before
    public void before() {
        this.idGeneratorFactory = (IdGeneratorFactory)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(IdGeneratorFactory.class);
    }

    static class Tracker
    implements RelationshipLocker,
    RecordAccessSet {
        private final RecordAccessSet delegate;
        private final TrackingRecordAccess<RelationshipRecord, Void> relRecords;
        private final Set<Long> relationshipLocksAcquired = new HashSet<Long>();
        private final Set<Long> changedRelationships = new HashSet<Long>();

        public Tracker(NeoStore neoStore) {
            this.delegate = new DirectRecordAccessSet(neoStore);
            this.relRecords = new TrackingRecordAccess(this.delegate.getRelRecords(), this);
        }

        public void getWriteLock(long relId) {
            this.relationshipLocksAcquired.add(relId);
        }

        protected void changingRelationship(long relId) {
            Assert.assertTrue((String)("Tried to change relationship " + relId + " without this transaction having it locked"), (boolean)this.relationshipLocksAcquired.contains(relId));
            this.changedRelationships.add(relId);
        }

        public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
            return this.delegate.getNodeRecords();
        }

        public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
            return this.delegate.getPropertyRecords();
        }

        public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
            return this.relRecords;
        }

        public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
            return this.delegate.getRelGroupRecords();
        }

        public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
            return this.delegate.getSchemaRuleChanges();
        }

        public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
            return this.delegate.getPropertyKeyTokenChanges();
        }

        public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenChanges() {
            return this.delegate.getLabelTokenChanges();
        }

        public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
            return this.delegate.getRelationshipTypeTokenChanges();
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasChanges() {
            return this.delegate.hasChanges();
        }
    }
}

