/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class TransactionRecordStateTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNode() throws Exception {
        NeoStore store = this.newNeoStore(new String[0]);
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE, new LockGroup(), 1L);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((NeoCommandHandler)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        this.apply((NeoCommandHandler)applier, this.transaction(this.deleteNode(store, nodeId.get())));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNodeForRecoveredTransaction() throws Exception {
        NeoStore store = this.newNeoStore(new String[0]);
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE, new LockGroup(), 1L);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((NeoCommandHandler)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        TransactionRepresentation transaction = this.transaction(this.deleteNode(store, nodeId.get()));
        InMemoryVersionableLogChannel channel = new InMemoryVersionableLogChannel();
        this.writeToChannel(transaction, channel);
        CommittedTransactionRepresentation recoveredTransaction = this.readFromChannel(channel);
        this.apply((NeoCommandHandler)applier, recoveredTransaction.getTransactionRepresentation());
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldExtractCreatedCommandsInCorrectOrder() throws Exception {
        NeoStore neoStore = this.newNeoStore(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(neoStore);
        NeoStoreTransactionContext context = new NeoStoreTransactionContext(supplier, neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        TransactionRecordState recordState = new TransactionRecordState(neoStore, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
        long nodeId = 0L;
        long relId = 1L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId++, 0, nodeId, nodeId);
        recordState.relCreate(relId, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, (Object)101);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((Command)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldExtractUpdateCommandsInCorrectOrder() throws Exception {
        NeoStore neoStore = this.newNeoStore(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(neoStore);
        NeoStoreTransactionContext context = new NeoStoreTransactionContext(supplier, neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        TransactionRecordState recordState = new TransactionRecordState(neoStore, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
        long nodeId = 0L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId3 = 3L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId1, 0, nodeId, nodeId);
        recordState.relCreate(relId2, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, (Object)101);
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(neoStore, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE, new LockGroup(), 1L);
        this.apply((NeoCommandHandler)applier, this.transaction(recordState));
        context = new NeoStoreTransactionContext(supplier, neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        recordState = new TransactionRecordState(neoStore, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
        recordState.nodeChangeProperty(nodeId, 0, (Object)102);
        recordState.relCreate(relId3, 0, nodeId, nodeId);
        recordState.relAddProperty(relId1, 0, (Object)123);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((Command)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldExtractDeleteCommandsInCorrectOrder() throws Exception {
        NeoStore neoStore = this.newNeoStore(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(neoStore);
        NeoStoreTransactionContext context = new NeoStoreTransactionContext(supplier, neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        TransactionRecordState recordState = new TransactionRecordState(neoStore, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
        long nodeId1 = 0L;
        long nodeId2 = 1L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId3 = 3L;
        long relId4 = 10L;
        recordState.nodeCreate(nodeId1);
        recordState.nodeCreate(nodeId2);
        recordState.relCreate(relId1, 0, nodeId1, nodeId1);
        recordState.relCreate(relId2, 0, nodeId1, nodeId1);
        recordState.relCreate(relId4, 1, nodeId1, nodeId1);
        recordState.nodeAddProperty(nodeId1, 0, (Object)101);
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(neoStore, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE, new LockGroup(), 1L);
        this.apply((NeoCommandHandler)applier, this.transaction(recordState));
        context = new NeoStoreTransactionContext(supplier, neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        recordState = new TransactionRecordState(neoStore, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
        recordState.relDelete(relId4);
        recordState.nodeDelete(nodeId2);
        recordState.nodeRemoveProperty(nodeId1, 0);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.NodeCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((Command)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    private void assertCommand(Command next, Class klass) {
        Assert.assertTrue((String)("Expected " + klass + ". was: " + next), (boolean)klass.isInstance(next));
    }

    private CommittedTransactionRepresentation readFromChannel(ReadableVersionableLogChannel channel) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor cursor = new PhysicalTransactionCursor((ReadableLogChannel)channel, (LogEntryReader)logEntryReader);){
            Assert.assertTrue((boolean)cursor.next());
            CommittedTransactionRepresentation committedTransactionRepresentation = cursor.get();
            return committedTransactionRepresentation;
        }
    }

    private void writeToChannel(TransactionRepresentation transaction, WritableLogChannel channel) throws IOException {
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter(channel, (NeoCommandHandler)new CommandWriter(channel)));
        writer.append(transaction, 2L);
    }

    private NeoStore newNeoStore(String ... config) {
        File storeDir = new File("dir");
        this.fsr.get().mkdirs(storeDir);
        Config configuration = StoreFactory.configForStoreDir((Config)new Config(MapUtil.stringMap((String[])config)), (File)storeDir);
        StoreFactory storeFactory = new StoreFactory(configuration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsr.get()), (FileSystemAbstraction)this.fsr.get(), StringLogger.DEV_NULL, new Monitors());
        return this.cleanup.add(storeFactory.newNeoStore(true));
    }

    private TransactionRecordState nodeWithDynamicLabelRecord(NeoStore store, AtomicLong nodeId, AtomicLong dynamicLabelRecordId) {
        NeoStoreTransactionContext context = this.context(store);
        TransactionRecordState recordState = this.recordState(store, context);
        nodeId.set(store.getNodeStore().nextId());
        int[] labelIds = new int[20];
        for (int i = 0; i < labelIds.length; ++i) {
            int labelId = (int)store.getLabelTokenStore().nextId();
            recordState.createLabelToken("Label" + i, labelId);
            labelIds[i] = labelId;
        }
        recordState.nodeCreate(nodeId.get());
        for (int labelId : labelIds) {
            recordState.addLabelToNode(labelId, nodeId.get());
        }
        NodeRecord node = (NodeRecord)((RecordAccess.RecordProxy)IteratorUtil.single((Iterable)context.getNodeRecords().changes())).forReadingData();
        dynamicLabelRecordId.set(((DynamicRecord)IteratorUtil.single((Iterable)node.getDynamicLabelRecords())).getId());
        return recordState;
    }

    private TransactionRecordState deleteNode(NeoStore store, long nodeId) {
        NeoStoreTransactionContext context = this.context(store);
        TransactionRecordState recordState = this.recordState(store, context);
        recordState.nodeDelete(nodeId);
        return recordState;
    }

    private void apply(NeoCommandHandler applier, TransactionRepresentation transaction) throws IOException {
        transaction.accept((Visitor)new CommandApplierFacade(new NeoCommandHandler[]{applier}));
    }

    private TransactionRecordState recordState(NeoStore store, NeoStoreTransactionContext context) {
        return new TransactionRecordState(store, new IntegrityValidator(store, (IndexingService)Mockito.mock(IndexingService.class)), context);
    }

    private NeoStoreTransactionContext context(NeoStore store) {
        NeoStoreTransactionContextSupplier contextSupplier = new NeoStoreTransactionContextSupplier(store);
        NeoStoreTransactionContext context = new NeoStoreTransactionContext(contextSupplier, store);
        return context;
    }

    private TransactionRepresentation transaction(TransactionRecordState recordState) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return transaction;
    }

    private void assertDynamicLabelRecordInUse(NeoStore store, long id, boolean inUse) {
        DynamicRecord record = store.getNodeStore().getDynamicLabelStore().forceGetRaw(id);
        Assert.assertTrue((inUse == record.inUse() ? 1 : 0) != 0);
    }
}

