/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.qa.tooling;

import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;
import org.neo4j.qa.tooling.DumpProcessInformation;
import org.neo4j.qa.tooling.DumpVmInformation;

public class DumpProcessInformationRule
extends ExternalResource {
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final long duration;
    private final TimeUnit timeUnit;
    private volatile ScheduledFuture<?> thunk = null;
    private final Dump[] dumps;

    public static Dump localVm(final PrintStream out) {
        return new Dump(){

            @Override
            public void dump() {
                DumpVmInformation.dumpVmInfo(out);
            }
        };
    }

    public static Dump otherVm(final Predicate<String> processFilter, final File baseDir) {
        return new Dump(){

            @Override
            public void dump() throws Exception {
                new DumpProcessInformation((Logging)new SystemOutLogging(), baseDir).doThreadDump((Predicate<String>)processFilter);
            }
        };
    }

    public DumpProcessInformationRule(long duration, TimeUnit timeUnit, Dump ... dumps) {
        this.duration = duration;
        this.timeUnit = timeUnit;
        this.dumps = dumps;
    }

    protected synchronized void before() throws Throwable {
        if (null != this.thunk) {
            throw new IllegalStateException("process dumping thunk already started");
        }
        super.before();
        this.thunk = this.executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DumpProcessInformationRule.this.dump();
                return null;
            }
        }, this.duration, this.timeUnit);
    }

    protected synchronized void after() {
        if (null != this.thunk && !this.thunk.isDone()) {
            this.thunk.cancel(true);
        }
        this.thunk = null;
        super.after();
    }

    public void dump() throws Exception {
        for (Dump dump : this.dumps) {
            dump.dump();
        }
    }

    public static interface Dump {
        public void dump() throws Exception;
    }
}

