/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.SubProcess;

public class AbstractSubProcessTestBase {
    protected final TargetDirectory target;
    protected final Pair<Instance, BreakPoint[]>[] instances;

    public AbstractSubProcessTestBase() {
        this(1);
    }

    protected AbstractSubProcessTestBase(int instances) {
        this.instances = new Pair[instances];
        this.target = TargetDirectory.forTest(this.getClass());
    }

    protected final void runInThread(Task task) {
        this.run(new ThreadTask(task));
    }

    protected final void run(Task task) {
        for (Pair<Instance, BreakPoint[]> instance : this.instances) {
            if (instance == null) continue;
            ((Instance)instance.first()).run(task);
        }
    }

    protected final void restart() {
        for (Pair<Instance, BreakPoint[]> instance : this.instances) {
            if (instance == null) continue;
            ((Instance)instance.first()).restart();
        }
    }

    protected BreakPoint[] breakpoints(int id) {
        return null;
    }

    @Before
    public final void startSubprocesses() throws IOException, InterruptedException {
        SubInstance prototype = new SubInstance();
        for (int i = 0; i < this.instances.length; ++i) {
            BreakPoint[] breakPoints = this.breakpoints(i);
            this.instances[i] = Pair.of(prototype.start(this.bootstrap(i), breakPoints), (Object)breakPoints);
        }
        for (Pair<Instance, BreakPoint[]> instance : this.instances) {
            if (instance == null) continue;
            ((Instance)instance.first()).awaitStarted();
        }
    }

    protected Bootstrapper bootstrap(int id) throws IOException {
        return this.bootstrap(id, new HashMap<String, String>());
    }

    protected Bootstrapper bootstrap(int id, Map<String, String> dbConfiguration) throws IOException {
        return new Bootstrapper(this, id, dbConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public final void stopSubprocesses() {
        Pair<Instance, BreakPoint[]>[] pairArray = this.instances;
        synchronized (this.instances) {
            for (int i = 0; i < this.instances.length; ++i) {
                Pair<Instance, BreakPoint[]> instance = this.instances[i];
                if (instance != null) {
                    SubProcess.stop(instance.first());
                }
                this.instances[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static File getStoreDir(AbstractSubProcessTestBase test, int instance) throws IOException {
        return test.target.cleanDirectory("graphdb." + instance);
    }

    protected static Bootstrapper killAwareBootstrapper(AbstractSubProcessTestBase test, int instance, Map<String, String> dbConfiguration) {
        try {
            return new KillAwareBootstrapper(test, instance, dbConfiguration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StartupFailureException
    extends RuntimeException {
        StartupFailureException(Throwable failure) {
            super(failure);
        }
    }

    private static class SubInstance
    extends SubProcess<Instance, Bootstrapper>
    implements Instance {
        private volatile GraphDatabaseAPI graphdb;
        private static final AtomicReferenceFieldUpdater<SubInstance, GraphDatabaseAPI> GRAPHDB = AtomicReferenceFieldUpdater.newUpdater(SubInstance.class, GraphDatabaseAPI.class, "graphdb");
        private volatile Bootstrapper bootstrap;
        private volatile Throwable failure;

        private SubInstance() {
        }

        @Override
        protected synchronized void startup(Bootstrapper bootstrap) {
            this.bootstrap = bootstrap;
            try {
                this.graphdb = (GraphDatabaseAPI)bootstrap.startup();
            }
            catch (Throwable failure) {
                this.failure = failure;
            }
        }

        @Override
        public void awaitStarted() throws InterruptedException {
            while (this.graphdb == null) {
                Throwable failure = this.failure;
                if (failure != null) {
                    throw new StartupFailureException(failure);
                }
                Thread.sleep(1L);
            }
        }

        @Override
        public void run(Task task) {
            task.run(this.graphdb);
        }

        @Override
        protected void shutdown(boolean normal) {
            Bootstrapper bootstrap = this.bootstrap;
            GraphDatabaseService graphdb = GRAPHDB.getAndSet(this, null);
            this.bootstrap = null;
            if (graphdb != null) {
                bootstrap.shutdown(graphdb, normal);
            }
            super.shutdown(normal);
        }

        @Override
        public void restart() {
            GraphDatabaseService graphdb;
            Bootstrapper bootstrap = this.bootstrap;
            while ((graphdb = (GraphDatabaseService)GRAPHDB.getAndSet(this, null)) == null) {
                bootstrap = this.bootstrap;
                if (bootstrap != null) continue;
                throw new IllegalStateException("instance has been shut down");
            }
            graphdb.shutdown();
            this.graphdb = (GraphDatabaseAPI)bootstrap.startup();
        }
    }

    private static class ThreadTask
    implements Task {
        private final Task task;
        private final Exception stackTraceOfOrigin;

        ThreadTask(Task task) {
            this.task = task;
            this.stackTraceOfOrigin = new Exception("Stack trace of thread that created this ThreadTask");
        }

        @Override
        public void run(final GraphDatabaseAPI graphdb) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThreadTask.this.task.run(graphdb);
                    }
                    catch (RuntimeException e) {
                        e.addSuppressed(ThreadTask.this.stackTraceOfOrigin);
                        throw e;
                    }
                }
            }, this.task.toString()).start();
        }
    }

    public static class KillAwareBootstrapper
    extends Bootstrapper {
        public KillAwareBootstrapper(AbstractSubProcessTestBase test, int instance, Map<String, String> dbConfiguration) throws IOException {
            super(test, instance, dbConfiguration);
        }

        @Override
        protected void shutdown(GraphDatabaseService graphdb, boolean normal) {
            if (normal) {
                super.shutdown(graphdb, normal);
            }
        }
    }

    public static class Bootstrapper
    implements Serializable {
        protected final String storeDir;
        private final Map<String, String> dbConfiguration;

        public Bootstrapper(AbstractSubProcessTestBase test, int instance) throws IOException {
            this(test, instance, new HashMap<String, String>());
        }

        public Bootstrapper(AbstractSubProcessTestBase test, int instance, Map<String, String> dbConfiguration) throws IOException {
            this.dbConfiguration = this.addVitalConfig(dbConfiguration);
            this.storeDir = AbstractSubProcessTestBase.getStoreDir(test, instance).getCanonicalPath();
        }

        private Map<String, String> addVitalConfig(Map<String, String> dbConfiguration) {
            return MapUtil.stringMap(new HashMap<String, String>(dbConfiguration), (String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "true", GraphDatabaseSettings.pagecache_memory.name(), "8m"});
        }

        protected GraphDatabaseService startup() {
            return new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(this.dbConfiguration).newGraphDatabase();
        }

        protected void shutdown(GraphDatabaseService graphdb, boolean normal) {
            graphdb.shutdown();
        }
    }

    public static interface Instance {
        public void run(Task var1);

        public void awaitStarted() throws InterruptedException;

        public void restart();
    }

    protected static interface Task
    extends Serializable {
        public void run(GraphDatabaseAPI var1);
    }
}

