/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Map;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.NoCacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.test.ExternalResource;
import org.neo4j.test.TargetDirectory;

public class NeoStoreDataSourceRule
extends ExternalResource {
    private NeoStoreDataSource theDs;

    public NeoStoreDataSource getDataSource(TargetDirectory.TestDirectory dir, FileSystemAbstraction fs, PageCache pageCache, Map<String, String> additionalConfig, KernelHealth kernelHealth) {
        if (this.theDs != null) {
            this.theDs.stop();
            this.theDs.shutdown();
        }
        Config config = new Config(MapUtil.stringMap(additionalConfig, (String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), dir.directory("dir").getPath(), InternalAbstractGraphDatabase.Configuration.neo_store.name(), "neo"}), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCache, fs, StringLogger.DEV_NULL, new Monitors());
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn(Mockito.mock(Locks.Client.class));
        DefaultCaches caches = new DefaultCaches(StringLogger.DEV_NULL, new Monitors());
        caches.configure((CacheProvider)new NoCacheProvider(), config);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS);
        this.theDs = new NeoStoreDataSource(config, sf, StringLogger.DEV_NULL, jobScheduler, DevNullLoggingService.DEV_NULL, (TokenNameLookup)Mockito.mock(TokenNameLookup.class), this.dependencyResolverForNoIndexProvider(), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), locks, (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, fs, (StoreUpgrader)Mockito.mock(StoreUpgrader.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), kernelHealth, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), TransactionHeaderInformationFactory.DEFAULT, new StartupStatisticsProvider(), (Caches)caches, (NodeManager)Mockito.mock(NodeManager.class), null, null, InternalAbstractGraphDatabase.defaultCommitProcessFactory, (PageCache)Mockito.mock(PageCache.class), (Monitors)Mockito.mock(Monitors.class), new Tracers("null", StringLogger.DEV_NULL));
        return this.theDs;
    }

    public NeoStoreDataSource getDataSource(TargetDirectory.TestDirectory dir, FileSystemAbstraction fs, PageCache pageCache, Map<String, String> additionalConfig) {
        KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), DevNullLoggingService.DEV_NULL);
        return this.getDataSource(dir, fs, pageCache, additionalConfig, kernelHealth);
    }

    private DependencyResolver dependencyResolverForNoIndexProvider() {
        return new DependencyResolver.Adapter(){
            private final LabelScanStoreProvider labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 10);

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (SchemaIndexProvider.class.isAssignableFrom(type)) {
                    return type.cast(SchemaIndexProvider.NO_INDEX_PROVIDER);
                }
                if (LabelScanStoreProvider.class.isAssignableFrom(type)) {
                    return type.cast(this.labelScanStoreProvider);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

