/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RandomizedTestRule
implements TestRule {
    private Random random;
    private long seed;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String key = description.getClassName() + ".SEED";
                RandomizedTestRule.this.seed = Long.getLong(key, ThreadLocalRandom.current().nextLong());
                RandomizedTestRule.this.random = new Random(RandomizedTestRule.this.seed);
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    System.err.println(description.getDisplayName() + " failed with random seed = " + RandomizedTestRule.this.seed + "\n  To re-run the test with the same seed, set the system property:" + "\n  -D" + key + "=" + RandomizedTestRule.this.seed);
                    throw t;
                }
                finally {
                    RandomizedTestRule.this.random = null;
                }
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[seed=" + this.seed + "]";
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }
}

