/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.helpers.Provider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.PageCacheRule;

public abstract class ResourceRule<RESOURCE>
implements TestRule,
Provider<RESOURCE> {
    private RESOURCE resource;

    public static ResourceRule<File> fileInExistingDirectory(final Provider<? extends FileSystemAbstraction> fs) {
        return new ResourceRule<File>(){

            @Override
            protected File createResource(Description description) {
                File path = ResourceRule.path(description);
                ((FileSystemAbstraction)fs.instance()).mkdir(path.getParentFile());
                return path;
            }
        };
    }

    public static ResourceRule<File> existingDirectory(final Provider<? extends FileSystemAbstraction> fs) {
        return new ResourceRule<File>(){

            @Override
            protected File createResource(Description description) {
                File path = ResourceRule.path(description);
                ((FileSystemAbstraction)fs.instance()).mkdir(path);
                return path;
            }
        };
    }

    public static ResourceRule<File> testPath() {
        return new ResourceRule<File>(){

            @Override
            protected File createResource(Description description) {
                return ResourceRule.path(description);
            }
        };
    }

    public static ResourceRule<PageCache> pageCache(final Provider<? extends FileSystemAbstraction> fs) {
        return new ResourceRule<PageCache>(){
            final PageCacheRule pageCache = new PageCacheRule();

            @Override
            protected PageCache createResource(Description description) {
                return this.pageCache.getPageCache((FileSystemAbstraction)fs.instance());
            }

            @Override
            protected void destroyResource(PageCache done, Throwable failure) {
                this.pageCache.after(failure == null);
            }
        };
    }

    private static File path(Description description) {
        return new File(description.getClassName(), description.getMethodName());
    }

    public final RESOURCE get() {
        return this.instance();
    }

    public final RESOURCE instance() {
        return this.resource;
    }

    public final Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ResourceRule.this.resource = ResourceRule.this.createResource(description);
                Throwable failure = null;
                try {
                    base.evaluate();
                }
                catch (Throwable err) {
                    failure = err;
                    throw err;
                }
                finally {
                    Object done = ResourceRule.this.resource;
                    ResourceRule.this.resource = null;
                    try {
                        ResourceRule.this.destroyResource(done, failure);
                    }
                    catch (Throwable err) {
                        if (failure != null) {
                            failure.addSuppressed(err);
                        }
                        throw err;
                    }
                }
            }
        };
    }

    protected abstract RESOURCE createResource(Description var1);

    protected void destroyResource(RESOURCE done, Throwable failure) {
    }
}

