/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseBuilder;
import org.neo4j.test.TestGraphDatabaseFactoryState;

public class TestGraphDatabaseFactory
extends GraphDatabaseFactory {
    public TestGraphDatabaseFactory() {
        super((GraphDatabaseFactoryState)new TestGraphDatabaseFactoryState());
    }

    public TestGraphDatabaseFactory(Logging logging) {
        super((GraphDatabaseFactoryState)new TestGraphDatabaseFactoryState());
        this.setLogging(logging);
    }

    public GraphDatabaseService newImpermanentDatabase() {
        return this.newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(String storeDir) {
        return this.newImpermanentDatabaseBuilder(storeDir).newGraphDatabase();
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder() {
        return this.newImpermanentDatabaseBuilder("target/test-data/impermanent-db");
    }

    protected void configure(GraphDatabaseBuilder builder) {
        super.configure(builder);
        builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
    }

    protected TestGraphDatabaseFactoryState getCurrentState() {
        return (TestGraphDatabaseFactoryState)super.getCurrentState();
    }

    protected TestGraphDatabaseFactoryState getStateCopy() {
        return new TestGraphDatabaseFactoryState(this.getCurrentState());
    }

    public FileSystemAbstraction getFileSystem() {
        return this.getCurrentState().getFileSystem();
    }

    public TestGraphDatabaseFactory setFileSystem(FileSystemAbstraction fileSystem) {
        this.getCurrentState().setFileSystem(fileSystem);
        return this;
    }

    public GraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }

    public TestGraphDatabaseFactory setLogging(Logging logging) {
        this.getCurrentState().setLogging(logging);
        return this;
    }

    public TestGraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        return (TestGraphDatabaseFactory)super.addKernelExtensions(newKernelExtensions);
    }

    public TestGraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        return (TestGraphDatabaseFactory)super.addKernelExtension(newKernelExtension);
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder(String storeDir) {
        TestGraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createImpermanentDatabaseCreator(storeDir, state);
        TestGraphDatabaseBuilder builder = this.createImpermanentGraphDatabaseBuilder(creator);
        this.configure(builder);
        return builder;
    }

    protected TestGraphDatabaseBuilder createImpermanentGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new TestGraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final String storeDir, final TestGraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Map<String, String> config) {
                return new ImpermanentGraphDatabase(storeDir, config, state.databaseDependencies()){

                    @Override
                    protected FileSystemAbstraction createFileSystemAbstraction() {
                        FileSystemAbstraction fs = state.getFileSystem();
                        if (fs != null) {
                            return fs;
                        }
                        return super.createFileSystemAbstraction();
                    }
                };
            }
        };
    }
}

