/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

class LabelScanValue {
    static final int RANGE_SIZE = 64;
    static final int RANGE_SIZE_BYTES = 8;
    long bits;

    LabelScanValue() {
    }

    LabelScanValue set(int index) {
        long mask = 1L << index;
        this.bits |= mask;
        return this;
    }

    LabelScanValue add(LabelScanValue other) {
        this.bits |= other.bits;
        return this;
    }

    LabelScanValue remove(LabelScanValue other) {
        this.bits &= other.bits ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    void clear() {
        this.bits = 0L;
    }

    boolean isEmpty() {
        return this.bits == 0L;
    }

    public String toString() {
        return String.valueOf(this.bits);
    }
}

