/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;

abstract class LabelScanValueIndexAccessor {
    protected final Seeker<LabelScanKey, LabelScanValue> cursor;
    long baseNodeId;
    protected long bits;
    private int prevLabel = -1;
    private long prevRange = -1L;
    protected boolean closed;

    LabelScanValueIndexAccessor(Seeker<LabelScanKey, LabelScanValue> cursor) {
        this.cursor = cursor;
    }

    boolean keysInOrder(LabelScanKey key) {
        assert (key.labelId >= this.prevLabel) : "Expected to get ordered results, got " + key + " where previous label was " + this.prevLabel;
        assert (key.idRange > this.prevRange) : "Expected to get ordered results, got " + key + " where previous range was " + this.prevRange;
        this.prevLabel = key.labelId;
        this.prevRange = key.idRange;
        return true;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

