/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.index.label.AllEntriesLabelScanReader;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.NodeLabelRange;

class NativeAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final IntFunction<Seeker<LabelScanKey, LabelScanValue>> seekProvider;
    private final List<Seeker<LabelScanKey, LabelScanValue>> cursors = new ArrayList<Seeker<LabelScanKey, LabelScanValue>>();
    private final int highestLabelId;

    NativeAllEntriesLabelScanReader(IntFunction<Seeker<LabelScanKey, LabelScanValue>> seekProvider, int highestLabelId) {
        this.seekProvider = seekProvider;
        this.highestLabelId = highestLabelId;
    }

    public long maxCount() {
        return -1L;
    }

    @Override
    public int rangeSize() {
        return 64;
    }

    public Iterator<NodeLabelRange> iterator() {
        try {
            long lowestRange = Long.MAX_VALUE;
            this.closeCursors();
            for (int labelId = 0; labelId <= this.highestLabelId; ++labelId) {
                Seeker<LabelScanKey, LabelScanValue> cursor = this.seekProvider.apply(labelId);
                if (!cursor.next()) continue;
                lowestRange = Long.min(lowestRange, ((LabelScanKey)cursor.key()).idRange);
                this.cursors.add(cursor);
            }
            return new NodeLabelRangeIterator(lowestRange);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCursors() throws IOException {
        for (Seeker<LabelScanKey, LabelScanValue> cursor : this.cursors) {
            cursor.close();
        }
        this.cursors.clear();
    }

    public void close() throws Exception {
        this.closeCursors();
    }

    private class NodeLabelRangeIterator
    extends PrefetchingIterator<NodeLabelRange> {
        private long currentRange;
        private final MutableLongList[] labelsForEachNode = new MutableLongList[64];

        NodeLabelRangeIterator(long lowestRange) {
            this.currentRange = lowestRange;
        }

        protected NodeLabelRange fetchNextOrNull() {
            if (this.currentRange == Long.MAX_VALUE) {
                return null;
            }
            Arrays.fill(this.labelsForEachNode, null);
            long nextLowestRange = Long.MAX_VALUE;
            try {
                for (Seeker<LabelScanKey, LabelScanValue> cursor : NativeAllEntriesLabelScanReader.this.cursors) {
                    long idRange = ((LabelScanKey)cursor.key()).idRange;
                    if (idRange < this.currentRange) {
                        assert (!cursor.next());
                        continue;
                    }
                    if (idRange == this.currentRange) {
                        long bits = ((LabelScanValue)cursor.value()).bits;
                        long labelId = ((LabelScanKey)cursor.key()).labelId;
                        NodeLabelRange.readBitmap(bits, labelId, this.labelsForEachNode);
                        if (!cursor.next()) continue;
                        nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)cursor.key()).idRange);
                        continue;
                    }
                    nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)cursor.key()).idRange);
                }
                NodeLabelRange range = new NodeLabelRange(this.currentRange, NodeLabelRange.convertState((LongList[])this.labelsForEachNode));
                this.currentRange = nextLowestRange;
                return range;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

