/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.index.label.CompositeLabelScanValueIterator;
import org.neo4j.internal.index.label.LabelScan;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.LabelScanValueIndexProgressor;
import org.neo4j.internal.index.label.LabelScanValueIterator;
import org.neo4j.internal.index.label.NativeLabelScanWriter;
import org.neo4j.kernel.api.index.IndexProgressor;

class NativeLabelScanReader
implements LabelScanReader {
    private final GBPTree<LabelScanKey, LabelScanValue> index;

    NativeLabelScanReader(GBPTree<LabelScanKey, LabelScanValue> index) {
        this.index = index;
    }

    @Override
    public PrimitiveLongResourceIterator nodesWithLabel(int labelId) {
        Seeker<LabelScanKey, LabelScanValue> cursor;
        try {
            cursor = this.seekerForLabel(0L, labelId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new LabelScanValueIterator(cursor, -1L);
    }

    @Override
    public PrimitiveLongResourceIterator nodesWithAnyOfLabels(long fromId, int ... labelIds) {
        List<PrimitiveLongResourceIterator> iterators = this.iteratorsForLabels(fromId, labelIds);
        return new CompositeLabelScanValueIterator(iterators, false);
    }

    @Override
    public LabelScan nodeLabelScan(int labelId) {
        try {
            long highestNodeIdForLabel = this.highestNodeIdForLabel(labelId);
            return new NativeLabelScan(labelId, highestNodeIdForLabel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long highestNodeIdForLabel(int labelId) throws IOException {
        try (Seeker seeker = this.index.seek((Object)new LabelScanKey(labelId, Long.MAX_VALUE), (Object)new LabelScanKey(labelId, Long.MIN_VALUE));){
            long l = seeker.next() ? (((LabelScanKey)seeker.key()).idRange + 1L) * 64L : 0L;
            return l;
        }
    }

    private List<PrimitiveLongResourceIterator> iteratorsForLabels(long fromId, int[] labelIds) {
        ArrayList<PrimitiveLongResourceIterator> iterators = new ArrayList<PrimitiveLongResourceIterator>();
        try {
            for (int labelId : labelIds) {
                Seeker<LabelScanKey, LabelScanValue> cursor = this.seekerForLabel(fromId, labelId);
                iterators.add(new LabelScanValueIterator(cursor, fromId));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return iterators;
    }

    private Seeker<LabelScanKey, LabelScanValue> seekerForLabel(long startId, int labelId) throws IOException {
        LabelScanKey from = new LabelScanKey(labelId, NativeLabelScanWriter.rangeOf(startId));
        LabelScanKey to = new LabelScanKey(labelId, Long.MAX_VALUE);
        return this.index.seek((Object)from, (Object)to);
    }

    private Seeker<LabelScanKey, LabelScanValue> seekerForLabel(long startId, long stopId, int labelId) throws IOException {
        LabelScanKey from = new LabelScanKey(labelId, NativeLabelScanWriter.rangeOf(startId));
        LabelScanKey to = new LabelScanKey(labelId, NativeLabelScanWriter.rangeOf(stopId));
        return this.index.seek((Object)from, (Object)to);
    }

    private class NativeLabelScan
    implements LabelScan {
        private final AtomicLong nextStart;
        private final int labelId;
        private final long max;

        NativeLabelScan(int labelId, long max) {
            this.labelId = labelId;
            this.max = max;
            this.nextStart = new AtomicLong(0L);
        }

        @Override
        public IndexProgressor initialize(IndexProgressor.NodeLabelClient client) {
            return this.init(client, 0L, Long.MAX_VALUE);
        }

        @Override
        public IndexProgressor initializeBatch(IndexProgressor.NodeLabelClient client, int sizeHint) {
            if (sizeHint == 0) {
                return IndexProgressor.EMPTY;
            }
            long size = this.roundUp(sizeHint);
            long start = this.nextStart.getAndAdd(size);
            long stop = Math.min(start + size, this.max);
            if (start >= this.max) {
                return IndexProgressor.EMPTY;
            }
            return this.init(client, start, stop);
        }

        private IndexProgressor init(IndexProgressor.NodeLabelClient client, long start, long stop) {
            Seeker<LabelScanKey, LabelScanValue> cursor;
            try {
                cursor = NativeLabelScanReader.this.seekerForLabel(start, stop, this.labelId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new LabelScanValueIndexProgressor(cursor, client);
        }

        private long roundUp(long sizeHint) {
            return (sizeHint / 64L + 1L) * 64L;
        }
    }
}

